/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class MutationsPage {
    int mutationCount;
    protected final BeepediaScreen beepedia;
    Entity parent;
    MutationTypes type;
    CustomBeeData beeData;
    protected int inputCounter;
    protected int outputCounter;
    protected final ResourceLocation infoIcon = new ResourceLocation("resourcefulbees", "textures/gui/jei/icons.png");
    protected final ResourceLocation mutationImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/mutate.png");
    protected final ResourceLocation mutationChanceImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/mutation_sparkles.png");

    protected MutationsPage(BeePage parent, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        this.beeData = parent.beeData;
        this.parent = parent.getBee();
        this.type = type;
        this.mutationCount = mutationCount;
        this.beepedia = beepedia;
    }

    public MutationsPage(EntityType<?> parentType, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        this.parent = parentType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        if (!(this.parent instanceof CustomBeeEntity)) {
            throw new IllegalStateException("Mutation Parent isn't valid bee... like how the hell did you even get this??");
        }
        this.beeData = ((CustomBeeEntity)this.parent).getBeeData();
        this.type = type;
        this.mutationCount = mutationCount;
        this.beepedia = beepedia;
    }

    public abstract void tick(int var1);

    public void draw(MatrixStack matrix, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        StringTextComponent mutationCountString = new StringTextComponent("x " + this.mutationCount);
        font.func_243248_b(matrix, (ITextComponent)mutationCountString.func_240699_a_(TextFormatting.GRAY), (float)xPos + 20.0f, (float)yPos + 4.0f, -1);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.mutationImage);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)169, (int)84, (int)169, (int)84);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.mutationChanceImage);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderUtils.renderEntity(matrix, this.parent, (World)this.beepedia.getMinecraft().field_71441_e, (float)xPos + 84.5f - 15.0f, (float)yPos + 6.0f, 45.0f, 1.25f);
    }

    public boolean mouseClick(int xPos, int yPos, int mouseX, int mouseY) {
        if (this.parent instanceof CustomBeeEntity) {
            CustomBeeEntity beeEntity = (CustomBeeEntity)this.parent;
            if (BeepediaScreen.mouseHovering((float)xPos + 84.5f - 20.0f, (float)yPos + 6.0f, 30, 30, mouseX, mouseY)) {
                if (BeepediaScreen.currScreenState.getPageID().equals(beeEntity.getBeeData().getName())) {
                    return false;
                }
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, beeEntity.getBeeData().getName());
                return true;
            }
        }
        return false;
    }

    public void drawTooltips(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
        if (BeepediaScreen.mouseHovering((float)xPos + 84.5f - 20.0f, (float)yPos + 6.0f, 30, 30, mouseX, mouseY)) {
            this.beepedia.drawEntityTooltip(matrix, this.beeData, mouseX, mouseY);
        }
        if (BeepediaScreen.mouseHovering(xPos, yPos, 16, 16, mouseX, mouseY)) {
            TranslationTextComponent text = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.mutations.mutation_count.tooltip");
            this.beepedia.func_238652_a_(matrix, (ITextComponent)text, mouseX, mouseY);
        }
    }

    protected void drawWeight(MatrixStack matrix, Double right, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        DecimalFormat decimalFormat = new DecimalFormat("##%");
        StringTextComponent text = new StringTextComponent(decimalFormat.format(right));
        int padding = font.func_238414_a_((ITextProperties)text) / 2;
        font.func_243248_b(matrix, (ITextComponent)text.func_240699_a_(TextFormatting.GRAY), (float)xPos - (float)padding, (float)yPos, -1);
    }

    protected void drawChance(MatrixStack matrix, Double right, int xPos, int yPos) {
        if (right >= 1.0) {
            return;
        }
        this.drawWeight(matrix, right, xPos, yPos);
    }

    public abstract String getSearch();
}

