/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.MutationsPage;
import com.resourcefulbees.resourcefulbees.entity.passive.CustomBeeEntity;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMutationPage
extends MutationsPage {
    Entity input;
    List<Pair<Double, EntityOutput>> outputs = new ArrayList<Pair<Double, EntityOutput>>();
    private Double outputChance;

    public EntityMutationPage(EntityType<?> parentType, EntityType<?> entity, Pair<Double, RandomCollection<EntityOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parentType, type, mutationCount, beepedia);
        this.input = entity.func_200721_a((World)beepedia.getMinecraft().field_71441_e);
        this.initOutputs(outputs);
    }

    public EntityMutationPage(BeePage parent, EntityType<?> entity, Pair<Double, RandomCollection<EntityOutput>> outputs, MutationTypes type, int mutationCount, BeepediaScreen beepedia) {
        super(parent, type, mutationCount, beepedia);
        this.input = entity.func_200721_a((World)beepedia.getMinecraft().field_71441_e);
        this.initOutputs(outputs);
    }

    private void initOutputs(Pair<Double, RandomCollection<EntityOutput>> outputs) {
        this.outputChance = (Double)outputs.getKey();
        RandomCollection collection = (RandomCollection)outputs.getRight();
        collection.getMap().forEach((b, m) -> this.outputs.add((Pair<Double, EntityOutput>)Pair.of((Object)collection.getAdjustedWeight(m.getWeight()), (Object)m)));
    }

    @Override
    public void tick(int ticksActive) {
        if (ticksActive % 20 == 0 && !BeeInfoUtils.isShiftPressed()) {
            ++this.outputCounter;
            if (this.outputCounter >= this.outputs.size()) {
                this.outputCounter = 0;
            }
        }
    }

    @Override
    public void draw(MatrixStack matrix, int xPos, int yPos) {
        super.draw(matrix, xPos, yPos);
        RenderUtils.renderEntity(matrix, this.input, (World)this.beepedia.getMinecraft().field_71441_e, (float)xPos + 27.0f, (float)yPos + 32.0f, 45.0f, 1.25f);
        EntityOutput output = (EntityOutput)this.outputs.get(this.outputCounter).getRight();
        Entity entity = output.getGuiEntity(this.beepedia.getMinecraft().field_71441_e);
        if (!output.getCompoundNBT().isEmpty()) {
            CompoundNBT nbt = entity.func_189511_e(new CompoundNBT());
            nbt.func_197643_a(output.getCompoundNBT());
            entity.func_70020_e(nbt);
        }
        RenderUtils.renderEntity(matrix, entity, (World)this.beepedia.getMinecraft().field_71441_e, (float)xPos + 117.0f, (float)yPos + 32.0f, -45.0f, 1.25f);
        this.drawWeight(matrix, (Double)this.outputs.get(this.outputCounter).getLeft(), xPos + 127, yPos + 59);
        if (this.outputChance < 1.0) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.infoIcon);
            this.beepedia.func_238474_b_(matrix, xPos + 84 - 20, yPos + 51, 16, 0, 9, 9);
            this.drawChance(matrix, this.outputChance, xPos + 84, yPos + 52);
        }
    }

    @Override
    public boolean mouseClick(int xPos, int yPos, int mouseX, int mouseY) {
        Entity output;
        if (super.mouseClick(xPos, yPos, mouseX, mouseY)) {
            return true;
        }
        if (this.input instanceof CustomBeeEntity) {
            CustomBeeEntity beeEntity = (CustomBeeEntity)this.input;
            if (BeepediaScreen.mouseHovering((float)xPos + 22.0f, (float)yPos + 27.0f, 30, 30, mouseX, mouseY)) {
                if (BeepediaScreen.currScreenState.getPageID().equals(beeEntity.getBeeData().getName())) {
                    return false;
                }
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, beeEntity.getBeeData().getName());
                return true;
            }
        }
        if ((output = ((EntityOutput)this.outputs.get(this.outputCounter).getRight()).getGuiEntity(this.beepedia.getMinecraft().field_71441_e)) instanceof CustomBeeEntity) {
            CustomBeeEntity beeEntity = (CustomBeeEntity)output;
            if (BeepediaScreen.mouseHovering((float)xPos + 112.0f, (float)yPos + 27.0f, 30, 30, mouseX, mouseY)) {
                if (BeepediaScreen.currScreenState.getPageID().equals(beeEntity.getBeeData().getName())) {
                    return false;
                }
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, beeEntity.getBeeData().getName());
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawTooltips(MatrixStack matrix, int xPos, int yPos, int mouseX, int mouseY) {
        super.drawTooltips(matrix, xPos, yPos, mouseX, mouseY);
        if (BeepediaScreen.mouseHovering((float)xPos + 22.0f, (float)yPos + 27.0f, 30, 30, mouseX, mouseY)) {
            this.beepedia.drawEntityTooltip(matrix, this.input, mouseX, mouseY);
        } else if (BeepediaScreen.mouseHovering((float)xPos + 112.0f, (float)yPos + 27.0f, 30, 30, mouseX, mouseY)) {
            EntityOutput output = (EntityOutput)this.outputs.get(this.outputCounter).getRight();
            ArrayList<Object> tooltip = new ArrayList<Object>();
            IFormattableTextComponent name = output.getEntityType().func_212546_e().func_230531_f_();
            IFormattableTextComponent id = new StringTextComponent(output.getEntityType().getRegistryName().toString()).func_240699_a_(TextFormatting.DARK_GRAY);
            tooltip.add(name);
            tooltip.add(id);
            tooltip.addAll(BeeInfoUtils.getBeeLore(output.getEntityType(), (World)Minecraft.func_71410_x().field_71441_e));
            if (!output.getCompoundNBT().isEmpty()) {
                if (BeeInfoUtils.isShiftPressed()) {
                    List<String> lore = BeeInfoUtils.getLoreLines(output.getCompoundNBT());
                    lore.forEach(l -> tooltip.add(new StringTextComponent(l).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple")))));
                } else {
                    tooltip.add(new TranslationTextComponent("gui.resourcefulbees.jei.tooltip.show_nbt").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"dark_purple"))));
                }
            }
            this.beepedia.func_243308_b(matrix, tooltip, mouseX, mouseY);
        }
        if (this.outputChance < 1.0 && BeepediaScreen.mouseHovering((float)xPos + 84.5f - 20.0f, (float)yPos + 51.0f, 8, 8, mouseX, mouseY)) {
            this.beepedia.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.category.mutation_chance.info"), mouseX, mouseY);
        }
    }

    @Override
    public String getSearch() {
        String search = this.input.func_200200_C_().getString();
        for (Pair<Double, EntityOutput> output : this.outputs) {
            search = String.format("%s %s", search, ((EntityOutput)output.getRight()).getGuiEntity(this.beepedia.getMinecraft().field_71441_e).func_145748_c_().getString());
        }
        return search;
    }
}

