/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.compat.jei.BiomeParser;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class SpawningPage
extends BeeDataPage {
    private int subScrollPos;
    private final int scrollHeight;
    List<ResourceLocation> biomeList;
    private final Button prevTab;
    private final Button nextTab;

    public SpawningPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
        this.beeData = beeData;
        this.prevTab = new ImageButton(xPos + 84 - 48, yPos + 6, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        this.nextTab = new ImageButton(xPos + 84 + 40, yPos + 6, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        beepedia.func_230480_a_(this.nextTab);
        beepedia.func_230480_a_(this.prevTab);
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.biomeList = BiomeParser.getBiomes(beeData);
        this.scrollHeight = this.biomeList.size() * 12;
    }

    private void toggleTab() {
        BeepediaScreen.currScreenState.setBiomesOpen(!BeepediaScreen.currScreenState.isBiomesOpen());
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent title = new TranslationTextComponent(BeepediaScreen.currScreenState.isBiomesOpen() ? "gui.resourcefulbees.beepedia.bee_subtab.spawning.biomes" : "gui.resourcefulbees.beepedia.bee_subtab.spawning");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 8.0f, -1);
        if (BeepediaScreen.currScreenState.isBiomesOpen()) {
            GL11.glEnable((int)3089);
            double scale = this.beepedia.getMinecraft().func_228018_at_().func_198100_s();
            int scissorY = (int)((double)this.beepedia.getMinecraft().func_228018_at_().func_198091_l() - (double)(this.yPos + 106) * scale);
            GL11.glScissor((int)((int)((double)this.xPos * scale)), (int)scissorY, (int)((int)(169.0 * scale)), (int)((int)(84.0 * scale)));
            for (int i = 0; i < this.biomeList.size(); ++i) {
                TranslationTextComponent text = new TranslationTextComponent(String.format("biome.%s.%s", this.biomeList.get(i).func_110624_b(), this.biomeList.get(i).func_110623_a()));
                font.func_243248_b(matrix, (ITextComponent)text.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 22.0f + (float)this.subScrollPos + (float)i * 12.0f, -1);
            }
            GL11.glDisable((int)3089);
        } else {
            TranslationTextComponent groupName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.spawning.group");
            TranslationTextComponent heightName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.spawning.height");
            TranslationTextComponent weightName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.spawning.weight");
            TranslationTextComponent lightName = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.spawning.light");
            groupName.func_230529_a_((ITextComponent)new StringTextComponent(String.format("%d - %d", this.beeData.getSpawnData().getMinGroupSize(), this.beeData.getSpawnData().getMaxGroupSize())));
            heightName.func_230529_a_((ITextComponent)new StringTextComponent(String.format("%d - %d", this.beeData.getSpawnData().getMinYLevel(), this.beeData.getSpawnData().getMaxYLevel())));
            weightName.func_230529_a_((ITextComponent)new StringTextComponent(String.format("%d", this.beeData.getSpawnData().getSpawnWeight())));
            lightName.func_230529_a_((ITextComponent)BeeInfoUtils.getLightName(this.beeData.getSpawnData().getLightLevel()));
            font.func_243248_b(matrix, (ITextComponent)groupName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 22.0f, -1);
            font.func_243248_b(matrix, (ITextComponent)heightName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 34.0f, -1);
            font.func_243248_b(matrix, (ITextComponent)weightName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 46.0f, -1);
            font.func_243248_b(matrix, (ITextComponent)lightName.func_240699_a_(TextFormatting.GRAY), (float)this.xPos, (float)this.yPos + 58.0f, -1);
        }
    }

    @Override
    public String getSearch() {
        return String.format("%s %s", this.biomeList.stream().map(b -> new TranslationTextComponent(String.format("biome.%s.%s", b.func_110624_b(), b.func_110623_a())).getString()).collect(Collectors.joining(" ")), BeeInfoUtils.getLightName(this.beeData.getSpawnData().getLightLevel()).getString());
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        if (!BeepediaScreen.currScreenState.isBiomesOpen()) {
            return false;
        }
        if (mouseX >= (double)this.xPos && mouseY >= (double)(this.yPos + 22) && mouseX <= (double)(this.xPos + 169) && mouseY <= (double)(this.yPos + 106)) {
            int boxHeight = 84;
            if (boxHeight > this.scrollHeight) {
                return true;
            }
            this.subScrollPos = (int)((double)this.subScrollPos + scrollAmount * 8.0);
            if (this.subScrollPos > 0) {
                this.subScrollPos = 0;
            } else if (this.subScrollPos < -(this.scrollHeight - boxHeight)) {
                this.subScrollPos = -(this.scrollHeight - boxHeight);
            }
            BeepediaScreen.currScreenState.setSpawningScroll(this.subScrollPos);
            return true;
        }
        return false;
    }

    @Override
    public void openPage() {
        super.openPage();
        this.nextTab.field_230694_p_ = true;
        this.prevTab.field_230694_p_ = true;
        this.subScrollPos = BeepediaScreen.currScreenState.getSpawningScroll();
        int boxHeight = 84;
        if (boxHeight > this.scrollHeight) {
            BeepediaScreen.currScreenState.setSpawningScroll(0);
            this.subScrollPos = 0;
        }
    }

    @Override
    public void closePage() {
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        super.closePage();
    }
}

