/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.honeydata.DefaultHoneyBottleData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyEffect;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ListButton;
import com.resourcefulbees.resourcefulbees.client.gui.widget.SubButtonList;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class HoneyPage
extends BeepediaPage {
    private final ImageButton prevTab;
    private final ImageButton nextTab;
    private SubButtonList beeList = null;
    private final HoneyBottleData bottleData;
    private String honeySearch;
    private final TranslationTextComponent text;
    private final int hunger;
    private final float saturation;
    private final ItemStack bottle;
    private List<HoneyEffect> effects = new ArrayList<HoneyEffect>();
    private static final int LIST_HEIGHT = 102;
    ResourceLocation hungerBar = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/hunger_bar.png");
    ResourceLocation hungerIcons = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/hunger.png");
    ResourceLocation saturationIcons = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/saturation.png");

    public HoneyPage(BeepediaScreen beepedia, HoneyBottleData bottleData, String id, int left, int top) {
        super(beepedia, left, top, id);
        this.bottleData = bottleData;
        this.initSearch();
        if (bottleData instanceof DefaultHoneyBottleData) {
            DefaultHoneyBottleData data = (DefaultHoneyBottleData)bottleData;
            this.bottle = new ItemStack((IItemProvider)data.bottle);
            this.hunger = Foods.field_226604_w_.func_221466_a();
            this.saturation = Foods.field_226604_w_.func_221469_b();
            this.text = new TranslationTextComponent("fluid.resourcefulbees.honey");
        } else {
            this.bottle = new ItemStack((IItemProvider)bottleData.getHoneyBottleRegistryObject().get());
            this.hunger = bottleData.getHunger();
            this.saturation = bottleData.getSaturation();
            this.effects = bottleData.getEffects();
            this.text = bottleData.doGenerateHoneyFluid() ? bottleData.getFluidTranslation() : bottleData.getBottleTranslation();
        }
        this.newListButton(this.bottle, (ITextComponent)this.text);
        this.prevTab = new ImageButton(this.xPos + 84 - 48, this.yPos + 40, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        this.nextTab = new ImageButton(this.xPos + 84 + 40, this.yPos + 40, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.toggleTab());
        beepedia.func_230480_a_(this.nextTab);
        beepedia.func_230480_a_(this.prevTab);
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
    }

    private void toggleTab() {
        BeepediaScreen.currScreenState.setHoneyEffectsActive(!BeepediaScreen.currScreenState.isHoneyEffectsActive());
        this.beeList.setActive(this.effects.isEmpty() || !BeepediaScreen.currScreenState.isHoneyEffectsActive());
    }

    private void initSearch() {
        this.honeySearch = "";
        if (this.bottleData.getHoneyBottleRegistryObject() != null) {
            this.honeySearch = this.honeySearch + " " + new TranslationTextComponent(((Item)this.bottleData.getHoneyBottleRegistryObject().get()).func_77658_a()).getString();
        }
        if (this.bottleData.getHoneyFluidBlockRegistryObject() != null) {
            this.honeySearch = this.honeySearch + " " + new TranslationTextComponent(((FlowingFluidBlock)this.bottleData.getHoneyFluidBlockRegistryObject().get()).func_149739_a()).getString();
        }
        if (this.bottleData.getHoneyBlockItemRegistryObject() != null) {
            this.honeySearch = this.honeySearch + " " + new TranslationTextComponent(((Item)this.bottleData.getHoneyBlockItemRegistryObject().get()).func_77658_a()).getString();
        }
        if (this.bottleData.getHoneyBucketItemRegistryObject() != null) {
            this.honeySearch = this.honeySearch + " " + new TranslationTextComponent(((Item)this.bottleData.getHoneyBucketItemRegistryObject().get()).func_77658_a()).getString();
        }
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        if (this.beeList == null) {
            return;
        }
        this.beeList.updateList();
        this.beepedia.drawSlotNoToolTip(matrix, this.bottle, this.xPos, this.yPos + 10);
        this.beepedia.getMinecraft().field_71446_o.func_110577_a(this.splitterImage);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)this.xPos, (int)(this.yPos - 14), (float)0.0f, (float)0.0f, (int)165, (int)100, (int)165, (int)100);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_243248_b(matrix, (ITextComponent)this.text.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 24.0f, (float)this.yPos + 12.0f, -1);
        this.drawHungerBar(matrix);
        if (BeepediaScreen.currScreenState.isHoneyEffectsActive() && !this.effects.isEmpty()) {
            this.drawEffectsList(matrix, this.xPos, this.yPos + 34);
        } else {
            this.drawBeesList(matrix, this.xPos, this.yPos + 34);
        }
    }

    private void initBeeList() {
        Map<String, BeePage> beePages = this.beepedia.getBees(this.bottle);
        TreeMap<String, ListButton> buttons = new TreeMap<String, ListButton>();
        for (Map.Entry<String, BeePage> e : beePages.entrySet()) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
            BeeJar.fillJar(stack, e.getValue().beeData);
            TranslationTextComponent translation = e.getValue().beeData.getTranslation();
            Button.IPressable onPress = button -> {
                BeepediaScreen.saveScreenState();
                this.beepedia.setActive(BeepediaScreen.PageType.BEE, (String)e.getKey());
            };
            ListButton button2 = new ListButton(0, 0, 100, 20, 0, 0, 20, this.listImage, stack, 2, 2, (ITextComponent)translation, 22, 6, onPress);
            this.beepedia.func_230480_a_(button2);
            button2.field_230694_p_ = false;
            buttons.put(e.getKey(), button2);
        }
        this.beeList = new SubButtonList(this.xPos, this.yPos + 54, 169, 102, 21, null, (SortedMap<String, ListButton>)buttons);
        this.beeList.setActive(false);
    }

    private void drawBeesList(MatrixStack matrix, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.honey.bees_list");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)xPos + 84.5f - (float)padding, (float)yPos + 8.0f, -1);
    }

    private void drawEffectsList(MatrixStack matrix, int xPos, int yPos) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        TranslationTextComponent title = new TranslationTextComponent("gui.resourcefulbees.beepedia.tab.honey.effects_list");
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)xPos + 84.5f - (float)padding, (float)yPos + 8.0f, -1);
        for (int i = 0; i < this.effects.size(); ++i) {
            Effect effect = this.effects.get(i).getEffect();
            TranslationTextComponent name = new TranslationTextComponent(effect.func_76393_a());
            int duration = this.effects.get((int)i).duration;
            name.func_230529_a_((ITextComponent)new StringTextComponent(String.format(" (%02d:%02d)", duration / 20 / 60, duration / 20 % 60)));
            StringTextComponent chance = new StringTextComponent(new DecimalFormat("##%").format(this.effects.get((int)i).chance));
            int pos = yPos + 20 + i * 21 + BeepediaScreen.currScreenState.getHoneyEffectsListPos();
            GL11.glEnable((int)3089);
            double scale = this.beepedia.getMinecraft().func_228018_at_().func_198100_s();
            int scissorY = (int)((double)this.beepedia.getMinecraft().func_228018_at_().func_198091_l() - (double)(this.yPos + 156) * scale);
            GL11.glScissor((int)((int)((double)this.xPos * scale)), (int)scissorY, (int)((int)(169.0 * scale)), (int)((int)(102.0 * scale)));
            this.beepedia.drawEmptySlot(matrix, xPos, pos);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_213248_ap().func_215288_a(effect);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
            AbstractGui.func_238470_a_((MatrixStack)matrix, (int)(xPos + 1), (int)(pos + 1), (int)this.beepedia.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)sprite);
            font.func_243248_b(matrix, (ITextComponent)name.func_240699_a_(effect.func_188408_i() ? TextFormatting.BLUE : TextFormatting.RED), (float)xPos + 22.0f, (float)pos + 1.0f, -1);
            if (this.effects.get((int)i).chance < 1.0f) {
                font.func_243248_b(matrix, (ITextComponent)chance.func_240699_a_(TextFormatting.DARK_GRAY), (float)xPos + 22.0f, (float)pos + 11.0f, -1);
            }
            GL11.glDisable((int)3089);
        }
    }

    private void drawHungerBar(MatrixStack matrix) {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        manager.func_110577_a(this.hungerBar);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.xPos + 23), (int)(this.yPos + 21), (float)0.0f, (float)0.0f, (int)90, (int)9, (int)90, (int)9);
        int pipPosition = 105;
        int pipCounter = Math.min(this.hunger, 20);
        manager.func_110577_a(this.hungerIcons);
        while (pipCounter > 1) {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.xPos + pipPosition), (int)(this.yPos + 21), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)18);
            pipCounter -= 2;
            pipPosition -= 9;
        }
        if (pipCounter == 1) {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.xPos + pipPosition), (int)(this.yPos + 21), (float)0.0f, (float)9.0f, (int)9, (int)9, (int)9, (int)18);
        }
        float saturationWidth = Math.min(this.saturation * 90.0f, 90.0f);
        float saturationRemainder = 90.0f - saturationWidth;
        float saturationStart = 24.0f + saturationRemainder;
        manager.func_110577_a(this.saturationIcons);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(this.xPos + (int)saturationStart), (int)(this.yPos + 21), (float)saturationRemainder, (float)0.0f, (int)((int)saturationWidth), (int)9, (int)90, (int)9);
    }

    @Override
    public String getSearch() {
        return this.honeySearch;
    }

    @Override
    public void openPage() {
        super.openPage();
        if (this.beeList == null) {
            this.initBeeList();
        }
        this.nextTab.field_230694_p_ = !this.effects.isEmpty();
        this.prevTab.field_230694_p_ = !this.effects.isEmpty();
        this.beeList.setActive(this.effects.isEmpty() || !BeepediaScreen.currScreenState.isHoneyEffectsActive());
        this.beeList.setScrollPos(BeepediaScreen.currScreenState.getHoneyBeeListPos());
        int iconHeight = 21;
        int effectsHeight = this.effects.size() * iconHeight;
        if (effectsHeight < 102) {
            BeepediaScreen.currScreenState.setHoneyEffectsListPos(0);
        } else if (BeepediaScreen.currScreenState.getHoneyEffectsListPos() > effectsHeight - 102) {
            BeepediaScreen.currScreenState.setHoneyEffectsListPos(effectsHeight - 102);
        }
    }

    @Override
    public void closePage() {
        super.closePage();
        this.nextTab.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        if (this.beeList != null) {
            this.beeList.setActive(false);
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        int startPos = 54;
        if (mouseX >= (double)this.xPos && mouseY >= (double)(this.yPos + startPos) && mouseX <= (double)(this.xPos + 169) && mouseY <= (double)(this.yPos + startPos + 102)) {
            if (this.effects.isEmpty() || !BeepediaScreen.currScreenState.isHoneyEffectsActive()) {
                this.beeList.updatePos((int)(scrollAmount * 8.0));
                BeepediaScreen.currScreenState.setHoneyBeeListPos(this.beeList.getScrollPos());
            } else {
                int scrollPos = BeepediaScreen.currScreenState.getHoneyEffectsListPos();
                int iconHeight = 21;
                int effectsHeight = this.effects.size() * iconHeight;
                if (effectsHeight < 102) {
                    return false;
                }
                if ((scrollPos = (int)((double)scrollPos + scrollAmount * 8.0)) > 0) {
                    scrollPos = 0;
                } else if (scrollPos < -(effectsHeight - 102)) {
                    scrollPos = -(effectsHeight - 102);
                }
                BeepediaScreen.currScreenState.setHoneyEffectsListPos(scrollPos);
            }
            return true;
        }
        return false;
    }
}

