/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.EntityMutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.ItemMutation;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeePage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.EntityMutationPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.mutations.ItemMutationPage;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BreedingPage
extends BeeDataPage {
    Map<Pair<String, String>, RandomCollection<CustomBeeData>> children;
    Map<Pair<String, String>, CustomBeeData> parents;
    List<BreedingObject> parentBreeding = new LinkedList<BreedingObject>();
    List<BreedingObject> childrenBreeding = new LinkedList<BreedingObject>();
    List<EntityMutationPage> entityMutationBreeding = new LinkedList<EntityMutationPage>();
    List<ItemMutationPage> itemMutationBreeding = new LinkedList<ItemMutationPage>();
    List<BreedingPageType> subPages = new LinkedList<BreedingPageType>();
    BreedingPageType activeSubPage;
    Button leftArrow;
    Button rightArrow;
    Button prevTab;
    Button nextTab;
    private final ResourceLocation breedingImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/breeding.png");
    private final ResourceLocation infoIcon = new ResourceLocation("resourcefulbees", "textures/gui/jei/icons.png");
    private final TranslationTextComponent parentsTitle = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.breeding.parents_title");
    private final TranslationTextComponent childrenTitle = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.breeding.children_title");
    private final TranslationTextComponent entityMutationsTitle = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.breeding.entity_mutations_title");
    private final TranslationTextComponent itemMutationsTitle = new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.breeding.item_mutations_title");
    private int activePage = 0;

    public BreedingPage(BeepediaScreen beepedia, CustomBeeData beeData, int xPos, int yPos, List<EntityMutation> mutations, List<ItemMutation> itemBreedMutation, BeePage parent) {
        super(beepedia, beeData, xPos, yPos, parent);
        this.children = BeeRegistry.getRegistry().getChildren(beeData);
        this.parents = BeeRegistry.getRegistry().getParents(beeData);
        this.children.forEach((p, l) -> l.getMap().forEach((w, b) -> this.childrenBreeding.add(new BreedingObject((Pair<String, String>)p, (CustomBeeData)b))));
        this.parents.forEach((p, b) -> this.parentBreeding.add(new BreedingObject((Pair<String, String>)p, (CustomBeeData)b)));
        mutations.forEach(b -> this.entityMutationBreeding.add(new EntityMutationPage(b.getParent(), b.getInput(), b.getOutputs(), MutationTypes.ENTITY, b.getMutaionCount(), beepedia)));
        itemBreedMutation.forEach(b -> this.itemMutationBreeding.add(new ItemMutationPage(b.getParent(), b.getInputs(), b.getOutputs(), MutationTypes.ITEM, b.getMutationCount(), beepedia)));
        this.leftArrow = new ImageButton(xPos + 84 - 28, yPos + 106 - 16, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.prevPage());
        this.rightArrow = new ImageButton(xPos + 84 + 20, yPos + 106 - 16, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.nextPage());
        this.prevTab = new ImageButton(xPos + 84 - 48, yPos + 6, 8, 11, 0, 0, 11, this.arrowImage, 16, 33, button -> this.prevTab());
        this.nextTab = new ImageButton(xPos + 84 + 40, yPos + 6, 8, 11, 8, 0, 11, this.arrowImage, 16, 33, button -> this.nextTab());
        this.leftArrow.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.nextTab.field_230694_p_ = false;
        beepedia.func_230480_a_(this.leftArrow);
        beepedia.func_230480_a_(this.rightArrow);
        beepedia.func_230480_a_(this.prevTab);
        beepedia.func_230480_a_(this.nextTab);
        if (!this.notBaseBreed()) {
            this.childrenBreeding = new LinkedList<BreedingObject>();
        }
        if (!this.parentBreeding.isEmpty()) {
            this.subPages.add(BreedingPageType.PARENTS);
        }
        if (!this.childrenBreeding.isEmpty()) {
            this.subPages.add(BreedingPageType.CHILDREN);
        }
        if (!this.entityMutationBreeding.isEmpty()) {
            this.subPages.add(BreedingPageType.ENTITY_MUTATIONS);
        }
        if (!this.itemMutationBreeding.isEmpty()) {
            this.subPages.add(BreedingPageType.ITEM_MUTATIONS);
        }
        if (BeepediaScreen.currScreenState.getBreedingTab() >= this.subPages.size()) {
            BeepediaScreen.currScreenState.setBreedingTab(this.subPages.size() - 1);
        }
        this.activeSubPage = this.subPages.get(BeepediaScreen.currScreenState.getBreedingTab());
        this.parentBreeding.sort((o1, o2) -> {
            if (o1.isBase) {
                return 1;
            }
            return -1;
        });
        this.childrenBreeding.sort((o1, o2) -> {
            if (o1.isBase) {
                return 1;
            }
            return -1;
        });
    }

    private void nextTab() {
        int tab = BeepediaScreen.currScreenState.getBreedingTab();
        if (++tab >= this.subPages.size()) {
            tab = 0;
        }
        BeepediaScreen.currScreenState.setBreedingTab(tab);
        this.updatePagePosition();
    }

    private void prevTab() {
        int tab = BeepediaScreen.currScreenState.getBreedingTab();
        if (--tab < 0) {
            tab = this.subPages.size() - 1;
        }
        BeepediaScreen.currScreenState.setBreedingTab(tab);
        this.updatePagePosition();
    }

    private void updatePagePosition() {
        switch (this.subPages.get(BeepediaScreen.currScreenState.getBreedingTab())) {
            case PARENTS: {
                if (this.activePage < 0) {
                    this.activePage = this.parentBreeding.size() - 1;
                } else if (this.activePage >= this.parentBreeding.size()) {
                    this.activePage = 0;
                }
                this.activeSubPage = BreedingPageType.PARENTS;
                break;
            }
            case CHILDREN: {
                if (this.activePage < 0) {
                    this.activePage = this.childrenBreeding.size() - 1;
                } else if (this.activePage >= this.childrenBreeding.size()) {
                    this.activePage = 0;
                }
                this.activeSubPage = BreedingPageType.CHILDREN;
                break;
            }
            case ITEM_MUTATIONS: {
                if (this.activePage < 0) {
                    this.activePage = this.itemMutationBreeding.size() - 1;
                } else if (this.activePage >= this.itemMutationBreeding.size()) {
                    this.activePage = 0;
                }
                this.activeSubPage = BreedingPageType.ITEM_MUTATIONS;
                break;
            }
            case ENTITY_MUTATIONS: {
                if (this.activePage < 0) {
                    this.activePage = this.entityMutationBreeding.size() - 1;
                } else if (this.activePage >= this.entityMutationBreeding.size()) {
                    this.activePage = 0;
                }
                this.activeSubPage = BreedingPageType.ENTITY_MUTATIONS;
                break;
            }
            default: {
                this.activePage = 0;
            }
        }
    }

    private void nextPage() {
        ++this.activePage;
        this.updatePagePosition();
        BeepediaScreen.currScreenState.setBreedingPage(this.activePage);
    }

    private void prevPage() {
        --this.activePage;
        this.updatePagePosition();
        BeepediaScreen.currScreenState.setBreedingPage(this.activePage);
    }

    @Override
    public void openPage() {
        super.openPage();
        int tab = BeepediaScreen.currScreenState.getBreedingTab();
        if (tab >= this.subPages.size()) {
            tab = this.subPages.size() - 1;
        }
        BeepediaScreen.currScreenState.setBreedingTab(tab);
        this.activeSubPage = this.subPages.get(tab);
    }

    @Override
    public void closePage() {
        super.closePage();
        this.leftArrow.field_230694_p_ = false;
        this.rightArrow.field_230694_p_ = false;
        this.prevTab.field_230694_p_ = false;
        this.nextTab.field_230694_p_ = false;
    }

    private int getCurrentListSize() {
        switch (this.activeSubPage) {
            case ENTITY_MUTATIONS: {
                return this.entityMutationBreeding.size();
            }
            case ITEM_MUTATIONS: {
                return this.itemMutationBreeding.size();
            }
            case CHILDREN: {
                return this.childrenBreeding.size();
            }
            case PARENTS: {
                return this.parentBreeding.size();
            }
        }
        return 0;
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        TranslationTextComponent title;
        this.showButtons();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        switch (this.activeSubPage) {
            case CHILDREN: {
                title = this.childrenTitle;
                break;
            }
            case ITEM_MUTATIONS: {
                title = this.itemMutationsTitle;
                break;
            }
            case ENTITY_MUTATIONS: {
                title = this.entityMutationsTitle;
                break;
            }
            default: {
                title = this.parentsTitle;
            }
        }
        int padding = font.func_238414_a_((ITextProperties)title) / 2;
        font.func_243248_b(matrix, (ITextComponent)title.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 8.0f, -1);
        if (this.getCurrentListSize() > 1) {
            StringTextComponent page = new StringTextComponent(String.format("%d / %d", this.activePage + 1, this.getCurrentListSize()));
            padding = font.func_238414_a_((ITextProperties)page) / 2;
            font.func_243248_b(matrix, (ITextComponent)page.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 84.5f - (float)padding, (float)this.yPos + 106.0f - 14.0f, -1);
        }
    }

    private boolean shouldShowButtons() {
        return this.subPages.size() > 1;
    }

    private void showButtons() {
        this.prevTab.field_230694_p_ = this.shouldShowButtons();
        this.nextTab.field_230694_p_ = this.shouldShowButtons();
        this.leftArrow.field_230694_p_ = this.getCurrentListSize() > 1;
        this.rightArrow.field_230694_p_ = this.getCurrentListSize() > 1;
    }

    private boolean notBaseBreed() {
        return this.parentBreeding.size() != 1 || this.childrenBreeding.size() != 1 || !this.parentBreeding.get((int)0).isBase || !this.childrenBreeding.get((int)0).isBase;
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        switch (this.activeSubPage) {
            case CHILDREN: {
                this.childrenBreeding.get(this.activePage).draw(matrix);
                break;
            }
            case ENTITY_MUTATIONS: {
                this.entityMutationBreeding.get(this.activePage).draw(matrix, this.xPos, this.yPos + 22);
                break;
            }
            case ITEM_MUTATIONS: {
                this.itemMutationBreeding.get(this.activePage).draw(matrix, this.xPos, this.yPos + 22);
                break;
            }
            case PARENTS: {
                this.parentBreeding.get(this.activePage).draw(matrix);
                break;
            }
        }
    }

    @Override
    public String getSearch() {
        String search = "";
        for (BreedingObject breedingObject : this.childrenBreeding) {
            search = String.format("%s %s %s %s", search, breedingObject.child.name.getString(), breedingObject.parent1Name.getString(), breedingObject.parent2Name.getString());
        }
        for (BreedingObject breedingObject : this.parentBreeding) {
            search = String.format("%s %s %s %s", search, breedingObject.child.name.getString(), breedingObject.parent1Name.getString(), breedingObject.parent2Name.getString());
        }
        return search;
    }

    @Override
    public void tick(int ticksActive) {
        switch (this.activeSubPage) {
            case CHILDREN: {
                this.childrenBreeding.get(this.activePage).tick(ticksActive);
                break;
            }
            case ENTITY_MUTATIONS: {
                this.entityMutationBreeding.get(this.activePage).tick(ticksActive);
                break;
            }
            case ITEM_MUTATIONS: {
                this.itemMutationBreeding.get(this.activePage).tick(ticksActive);
                break;
            }
            case PARENTS: {
                this.parentBreeding.get(this.activePage).tick(ticksActive);
                break;
            }
        }
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        switch (this.activeSubPage) {
            case CHILDREN: {
                this.childrenBreeding.get(this.activePage).drawTooltips(matrixStack, mouseX, mouseY);
                break;
            }
            case ENTITY_MUTATIONS: {
                this.entityMutationBreeding.get(this.activePage).drawTooltips(matrixStack, this.xPos, this.yPos + 22, mouseX, mouseY);
                break;
            }
            case ITEM_MUTATIONS: {
                this.itemMutationBreeding.get(this.activePage).drawTooltips(matrixStack, this.xPos, this.yPos + 22, mouseX, mouseY);
                break;
            }
            case PARENTS: {
                this.parentBreeding.get(this.activePage).drawTooltips(matrixStack, mouseX, mouseY);
                break;
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        switch (this.activeSubPage) {
            case CHILDREN: {
                return this.childrenBreeding.get(this.activePage).mouseClicked(mouseX, mouseY);
            }
            case ENTITY_MUTATIONS: {
                return this.entityMutationBreeding.get(this.activePage).mouseClick(this.xPos, this.yPos + 22, (int)mouseX, (int)mouseY);
            }
            case ITEM_MUTATIONS: {
                return this.itemMutationBreeding.get(this.activePage).mouseClick(this.xPos, this.yPos + 22, (int)mouseX, (int)mouseY);
            }
            case PARENTS: {
                return this.parentBreeding.get(this.activePage).mouseClicked(mouseX, mouseY);
            }
        }
        return false;
    }

    private static enum BreedingPageType {
        PARENTS,
        CHILDREN,
        ENTITY_MUTATIONS,
        ITEM_MUTATIONS;

    }

    public class BreedingObject {
        Entity parent1Entity;
        Entity parent2Entity;
        CustomBeeData parent1Data;
        CustomBeeData parent2Data;
        List<ItemStack> parent1Items = new LinkedList<ItemStack>();
        List<ItemStack> parent2Items = new LinkedList<ItemStack>();
        TranslationTextComponent parent1Name;
        TranslationTextComponent parent2Name;
        Vector2f parent1Pos;
        Vector2f parent2Pos;
        Vector2f childPos;
        Vector2f chancePos;
        int parent1Counter = 0;
        int parent2Counter = 0;
        Child child;
        boolean isParent;
        DecimalFormat decimalFormat = new DecimalFormat("##%");
        public boolean isBase;

        private void initParents(Pair<String, String> parents) {
            this.parent1Data = BeeRegistry.getRegistry().getBeeData((String)parents.getLeft());
            this.parent2Data = BeeRegistry.getRegistry().getBeeData((String)parents.getRight());
            this.parent1Entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(this.parent1Data.getEntityTypeRegistryID())).func_200721_a((World)BreedingPage.this.beepedia.getMinecraft().field_71441_e);
            this.parent1Name = this.parent1Data.getTranslation();
            this.parent2Entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(this.parent2Data.getEntityTypeRegistryID())).func_200721_a((World)BreedingPage.this.beepedia.getMinecraft().field_71441_e);
            this.parent2Name = this.parent2Data.getTranslation();
            this.parent1Items = BeeInfoUtils.getBreedItems(this.parent1Data);
            this.parent2Items = BeeInfoUtils.getBreedItems(this.parent2Data);
            this.parent1Pos = new Vector2f((float)BreedingPage.this.xPos + 6.0f, (float)BreedingPage.this.yPos + 22.0f);
            this.parent2Pos = new Vector2f((float)BreedingPage.this.xPos + 60.0f, (float)BreedingPage.this.yPos + 22.0f);
            this.childPos = new Vector2f((float)BreedingPage.this.xPos + 130.0f, (float)BreedingPage.this.yPos + 32.0f);
            this.chancePos = new Vector2f((float)BreedingPage.this.xPos + 169.0f - 17.0f, (float)BreedingPage.this.yPos + 20.0f);
        }

        public BreedingObject(Pair<String, String> parents, CustomBeeData child) {
            this.initParents(parents);
            this.child = new Child(parents, child);
            this.isBase = ((String)parents.getLeft()).equals(parents.getRight()) && ((String)parents.getLeft()).equals(child.getName());
            this.isParent = false;
        }

        public void drawParent1(MatrixStack matrix) {
            RenderUtils.renderEntity(matrix, this.parent1Entity, (World)BreedingPage.this.beepedia.getMinecraft().field_71441_e, this.parent1Pos.field_189982_i, this.parent1Pos.field_189983_j, 45.0f, 1.0f);
        }

        public void drawParent2(MatrixStack matrix) {
            RenderUtils.renderEntity(matrix, this.parent2Entity, (World)BreedingPage.this.beepedia.getMinecraft().field_71441_e, this.parent2Pos.field_189982_i, this.parent2Pos.field_189983_j, -45.0f, 1.0f);
        }

        private void drawChild(MatrixStack matrix) {
            int padding;
            StringTextComponent text;
            FontRenderer font = BreedingPage.this.beepedia.getMinecraft().field_71466_p;
            RenderUtils.renderEntity(matrix, this.child.entity, (World)BreedingPage.this.beepedia.getMinecraft().field_71441_e, this.childPos.field_189982_i, this.childPos.field_189983_j, -45.0f, 1.0f);
            if (this.child.chance < 1.0 && !this.isBase) {
                text = new StringTextComponent(this.decimalFormat.format(this.child.chance));
                padding = font.func_238414_a_((ITextProperties)text) / 2;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(BreedingPage.this.infoIcon);
                BreedingPage.this.beepedia.func_238474_b_(matrix, (int)this.chancePos.field_189982_i, (int)this.chancePos.field_189983_j, 16, 0, 9, 9);
                font.func_243248_b(matrix, (ITextComponent)text.func_240699_a_(TextFormatting.GRAY), (float)BreedingPage.this.xPos + 140.0f - (float)padding, (float)BreedingPage.this.yPos + 21.0f, -1);
            }
            text = new StringTextComponent(this.decimalFormat.format(this.child.weight));
            padding = font.func_238414_a_((ITextProperties)text) / 2;
            font.func_243248_b(matrix, (ITextComponent)text.func_240699_a_(TextFormatting.GRAY), (float)BreedingPage.this.xPos + 103.0f - (float)padding, (float)BreedingPage.this.yPos + 56.0f, -1);
        }

        public void drawParent1Item(MatrixStack matrix) {
            if (this.parent1Items.isEmpty()) {
                return;
            }
            BreedingPage.this.beepedia.drawSlot(matrix, this.parent1Items.get(this.parent1Counter), BreedingPage.this.xPos + 5, BreedingPage.this.yPos + 53);
        }

        public void drawParent2Item(MatrixStack matrix) {
            if (this.parent1Items.isEmpty()) {
                return;
            }
            BreedingPage.this.beepedia.drawSlot(matrix, this.parent2Items.get(this.parent2Counter), BreedingPage.this.xPos + 59, BreedingPage.this.yPos + 53);
        }

        public void tick(int ticksActive) {
            if (ticksActive % 20 == 0 && !BeeInfoUtils.isShiftPressed()) {
                ++this.parent1Counter;
                if (this.parent1Counter >= this.parent1Items.size()) {
                    this.parent1Counter = 0;
                }
                ++this.parent2Counter;
                if (this.parent2Counter >= this.parent2Items.size()) {
                    this.parent2Counter = 0;
                }
            }
        }

        public void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
            if (BeepediaScreen.mouseHovering(this.parent1Pos.field_189982_i, this.parent1Pos.field_189983_j, 20, 20, mouseX, mouseY)) {
                BreedingPage.this.beepedia.drawEntityTooltip(matrixStack, this.parent1Data, mouseX, mouseY);
            }
            if (BeepediaScreen.mouseHovering(this.parent2Pos.field_189982_i, this.parent2Pos.field_189983_j, 20, 20, mouseX, mouseY)) {
                BreedingPage.this.beepedia.drawEntityTooltip(matrixStack, this.parent2Data, mouseX, mouseY);
            }
            if (BeepediaScreen.mouseHovering(this.childPos.field_189982_i, this.childPos.field_189983_j, 20, 20, mouseX, mouseY)) {
                BreedingPage.this.beepedia.drawEntityTooltip(matrixStack, this.child.beeData, mouseX, mouseY);
            }
            if (BeepediaScreen.mouseHovering(this.chancePos.field_189982_i, this.chancePos.field_189983_j, 9, 9, mouseX, mouseY) && this.child.chance < 1.0) {
                BreedingPage.this.beepedia.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.jei.category.breed_chance.info"), mouseX, mouseY);
            }
        }

        public void draw(MatrixStack matrix) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BreedingPage.this.breedingImage);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)BreedingPage.this.xPos, (int)(BreedingPage.this.yPos + 22), (float)0.0f, (float)0.0f, (int)128, (int)64, (int)128, (int)64);
            this.drawParent1(matrix);
            this.drawParent2(matrix);
            this.drawChild(matrix);
            this.drawParent1Item(matrix);
            this.drawParent2Item(matrix);
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            if (BeepediaScreen.mouseHovering(this.parent1Pos.field_189982_i, this.parent1Pos.field_189983_j, 20, 20, (int)mouseX, (int)mouseY)) {
                return this.openBeePage(this.parent1Data);
            }
            if (BeepediaScreen.mouseHovering(this.parent2Pos.field_189982_i, this.parent2Pos.field_189983_j, 20, 20, (int)mouseX, (int)mouseY)) {
                return this.openBeePage(this.parent2Data);
            }
            if (BeepediaScreen.mouseHovering(this.childPos.field_189982_i, this.childPos.field_189983_j, 20, 20, (int)mouseX, (int)mouseY)) {
                return this.openBeePage(this.child.beeData);
            }
            return false;
        }

        private boolean openBeePage(CustomBeeData beeData) {
            if (beeData.getName().equals(BreedingPage.this.id)) {
                return false;
            }
            BeepediaScreen.saveScreenState();
            BreedingPage.this.beepedia.setActive(BeepediaScreen.PageType.BEE, beeData.getName());
            return true;
        }

        public class Child {
            Entity entity;
            TranslationTextComponent name;
            double weight;
            double chance;
            CustomBeeData beeData;

            public Child(Pair<String, String> parents, CustomBeeData beeData) {
                this.entity = ((EntityType)ForgeRegistries.ENTITIES.getValue(beeData.getEntityTypeRegistryID())).func_200721_a((World)BreedingPage.this.beepedia.getMinecraft().field_71441_e);
                this.name = beeData.getTranslation();
                this.weight = BeeRegistry.getRegistry().getAdjustedWeightForChild(beeData, (String)parents.getLeft(), (String)parents.getRight());
                this.chance = beeData.getBreedData().getBreedChance();
                this.beeData = beeData;
            }
        }
    }
}

