/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.api.beedata.CustomBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.EntityMutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.ItemMutation;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.BeepediaScreen;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeDataPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BeeInfoPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.BreedingPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.HoneycombPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.MutationListPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.SpawningPage;
import com.resourcefulbees.resourcefulbees.client.gui.screen.beepedia.pages.TraitListPage;
import com.resourcefulbees.resourcefulbees.client.gui.widget.TabImageButton;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.item.BeeJar;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class BeePage
extends BeepediaPage {
    public CustomBeeData beeData;
    private Entity bee = null;
    protected Pair<TabImageButton, BeeDataPage> subPage;
    Pair<TabImageButton, BeeDataPage> beeInfoPage;
    Pair<TabImageButton, BeeDataPage> mutations;
    Pair<TabImageButton, BeeDataPage> traitListPage;
    Pair<TabImageButton, BeeDataPage> centrifugePage;
    Pair<TabImageButton, BeeDataPage> spawningPage;
    Pair<TabImageButton, BeeDataPage> breedingPage;
    List<Pair<TabImageButton, BeeDataPage>> tabs = new ArrayList<Pair<TabImageButton, BeeDataPage>>();
    ResourceLocation buttonImage = new ResourceLocation("resourcefulbees", "textures/gui/beepedia/button.png");
    private int tabCounter;
    IFormattableTextComponent label;
    public boolean beeUnlocked;
    private String search = null;

    public BeePage(BeepediaScreen beepedia, CustomBeeData beeData, String id, int xPos, int yPos) {
        super(beepedia, xPos, yPos, id);
        this.beeData = beeData;
        int subX = this.xPos + 1;
        int subY = this.yPos + 50;
        this.beeUnlocked = beepedia.itemBees.contains(id) || beepedia.complete;
        this.tabCounter = 0;
        this.beeInfoPage = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)Items.field_151122_aG), onPress -> this.setSubPage(SubPageType.INFO), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.info"))), (Object)new BeeInfoPage(beepedia, beeData, subX, subY, this));
        this.subPage = this.beeInfoPage;
        this.tabs.add(this.beeInfoPage);
        if (beeData.getMutationData().testMutations() && (!((Boolean)Config.BEEPEDIA_HIDE_LOCKED.get()).booleanValue() || this.beeUnlocked)) {
            this.mutations = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)Items.field_151071_bq), onPress -> this.setSubPage(SubPageType.MUTATIONS), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.mutations"))), (Object)new MutationListPage(beepedia, beeData, subX, subY, this));
            this.tabs.add(this.mutations);
        }
        if (beeData.getTraitData().hasTraits() && beeData.hasTraitNames() && (!((Boolean)Config.BEEPEDIA_HIDE_LOCKED.get()).booleanValue() || this.beeUnlocked)) {
            this.traitListPage = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)Items.field_151065_br), onPress -> this.setSubPage(SubPageType.TRAIT_LIST), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.traits"))), (Object)new TraitListPage(beepedia, beeData, subX, subY, this));
            this.tabs.add(this.traitListPage);
        }
        if (beeData.hasHoneycomb() && (!((Boolean)Config.BEEPEDIA_HIDE_LOCKED.get()).booleanValue() || this.beeUnlocked) && beeData.getCombRegistryObject().isPresent()) {
            this.centrifugePage = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)Items.field_226635_pU_), onPress -> this.setSubPage(SubPageType.HONEYCOMB), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.honeycombs"))), (Object)new HoneycombPage(beepedia, beeData, subX, subY, this));
            this.tabs.add(this.centrifugePage);
        }
        if (beeData.getSpawnData().canSpawnInWorld()) {
            this.spawningPage = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)Items.field_221671_bX), onPress -> this.setSubPage(SubPageType.SPAWNING), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.spawning"))), (Object)new SpawningPage(beepedia, beeData, subX, subY, this));
            this.tabs.add(this.spawningPage);
        }
        List<EntityMutation> breedMutations = BeeRegistry.getRegistry().getMutationsContaining(beeData);
        List<ItemMutation> itemBreedMutation = BeeRegistry.getRegistry().getItemMutationsContaining(beeData);
        if (beeData.getBreedData().isBreedable() || !breedMutations.isEmpty() || !itemBreedMutation.isEmpty()) {
            this.breedingPage = Pair.of((Object)((Object)this.getTabButton(new ItemStack((IItemProvider)ModItems.GOLD_FLOWER_ITEM.get()), onPress -> this.setSubPage(SubPageType.BREEDING), (ITextComponent)new TranslationTextComponent("gui.resourcefulbees.beepedia.bee_subtab.breeding"))), (Object)new BreedingPage(beepedia, beeData, subX, subY, breedMutations, itemBreedMutation, this));
            this.tabs.add(this.breedingPage);
        }
        ItemStack beeJar = new ItemStack((IItemProvider)ModItems.BEE_JAR.get());
        BeeJar.fillJar(beeJar, beeData);
        StringTextComponent star = new StringTextComponent(this.beeUnlocked ? TextFormatting.GREEN + "\u2726 " + TextFormatting.RESET : "\u2727 ");
        star.func_230529_a_((ITextComponent)beeData.getTranslation());
        this.label = star;
        this.newListButton(beeJar, (ITextComponent)this.label);
    }

    public TabImageButton getTabButton(ItemStack stack, Button.IPressable pressable, ITextComponent tooltip) {
        TabImageButton button = new TabImageButton(this.xPos + 40 + this.tabCounter * 21, this.yPos + 27, 20, 20, 0, 0, 20, this.buttonImage, stack, 2, 2, pressable, this.beepedia.getTooltipProvider(tooltip));
        this.beepedia.func_230480_a_(button);
        button.field_230694_p_ = false;
        ++this.tabCounter;
        return button;
    }

    @Override
    public void renderBackground(MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        this.beepedia.getMinecraft().field_71446_o.func_110577_a(this.splitterImage);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)this.xPos, (int)this.yPos, (float)0.0f, (float)0.0f, (int)165, (int)100, (int)165, (int)100);
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrix, (ITextComponent)this.label.func_240699_a_(TextFormatting.WHITE), (float)this.xPos + 40.0f, (float)this.yPos + 10.0f, -1);
        ((BeeDataPage)this.subPage.getRight()).renderBackground(matrix, partialTick, mouseX, mouseY);
        GL11.glEnable((int)3089);
        double scale = this.beepedia.getMinecraft().func_228018_at_().func_198100_s();
        int scissorY = (int)((double)this.beepedia.getMinecraft().func_228018_at_().func_198091_l() - (double)(this.yPos + 9 + 38) * scale);
        GL11.glScissor((int)((int)((double)this.xPos * scale)), (int)scissorY, (int)((int)(38.0 * scale)), (int)((int)(38.0 * scale)));
        RenderUtils.renderEntity(matrix, this.getBee(), (World)Minecraft.func_71410_x().field_71441_e, (float)this.xPos + 10.0f, (float)this.yPos + 2.0f, -45.0f, 2.0f);
        GL11.glDisable((int)3089);
    }

    @Override
    public void openPage() {
        super.openPage();
        if (BeepediaScreen.currScreenState.getPageID() != null) {
            this.setSubPage(BeepediaScreen.currScreenState.getBeeSubPage());
        } else {
            this.setSubPage(SubPageType.INFO);
        }
        this.tabs.forEach(p -> {
            ((TabImageButton)((Object)((Object)p.getLeft()))).field_230694_p_ = true;
        });
    }

    @Override
    public void closePage() {
        super.closePage();
        if (this.subPage != null) {
            ((BeeDataPage)this.subPage.getRight()).closePage();
        }
        this.tabs.forEach(p -> {
            ((TabImageButton)((Object)((Object)p.getLeft()))).field_230694_p_ = false;
        });
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        ((BeeDataPage)this.subPage.getRight()).renderForeground(matrix, mouseX, mouseY);
    }

    @Override
    public String getSearch() {
        if (this.search == null) {
            this.search = this.beeData.getTranslation().getString();
            for (Pair<TabImageButton, BeeDataPage> tab : this.tabs) {
                this.search = String.format("%s %s", this.search, ((BeeDataPage)tab.getRight()).getSearch());
            }
        }
        return this.search;
    }

    @Override
    public void tick(int ticksActive) {
        ((BeeDataPage)this.subPage.getRight()).tick(ticksActive);
    }

    @Override
    public void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (BeepediaScreen.mouseHovering(this.xPos, (float)this.yPos + 9.0f, 38, 38, mouseX, mouseY)) {
            this.beepedia.drawEntityLore(matrixStack, this.beeData, mouseX, mouseY);
        }
        ((BeeDataPage)this.subPage.getRight()).drawTooltips(matrixStack, mouseX, mouseY);
        this.tabs.forEach(p -> ((TabImageButton)((Object)((Object)p.getLeft()))).func_230443_a_(matrixStack, mouseX, mouseY));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        return ((BeeDataPage)this.subPage.getRight()).mouseScrolled(mouseX, mouseY, scrollAmount);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return ((BeeDataPage)this.subPage.getRight()).mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void setSubPage(SubPageType beeSubPage) {
        Pair<TabImageButton, BeeDataPage> page;
        switch (beeSubPage) {
            case BREEDING: {
                page = this.breedingPage;
                break;
            }
            case INFO: {
                page = this.beeInfoPage;
                break;
            }
            case SPAWNING: {
                page = this.spawningPage;
                break;
            }
            case MUTATIONS: {
                page = this.mutations;
                break;
            }
            case HONEYCOMB: {
                page = this.centrifugePage;
                break;
            }
            case TRAIT_LIST: {
                page = this.traitListPage;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)beeSubPage));
            }
        }
        if (this.subPage != null) {
            ((BeeDataPage)this.subPage.getRight()).closePage();
            ((TabImageButton)((Object)this.subPage.getLeft())).field_230693_o_ = true;
        }
        Pair<TabImageButton, BeeDataPage> pair = this.subPage = page == null ? this.beeInfoPage : page;
        if (this.subPage != null) {
            if (!(this.subPage.getRight() instanceof SpawningPage)) {
                BeepediaScreen.currScreenState.setBiomesOpen(false);
                BeepediaScreen.currScreenState.setSpawningScroll(0);
            }
            if (!(this.subPage.getRight() instanceof TraitListPage)) {
                BeepediaScreen.currScreenState.setTraitsScroll(0);
            }
            ((TabImageButton)((Object)this.subPage.getLeft())).field_230693_o_ = false;
            ((BeeDataPage)this.subPage.getRight()).openPage();
        }
        BeepediaScreen.currScreenState.setBeeSubPage(beeSubPage);
    }

    public Entity getBee() {
        if (this.bee == null) {
            this.bee = this.beepedia.initEntity(this.beeData.getEntityTypeRegistryID());
        }
        return this.bee;
    }

    public static enum SubPageType {
        INFO,
        SPAWNING,
        BREEDING,
        MUTATIONS,
        HONEYCOMB,
        TRAIT_LIST;

    }
}

