/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.resourcefulbees.resourcefulbees.client.gui.widget.ArrowButton;
import com.resourcefulbees.resourcefulbees.container.UnvalidatedApiaryContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.BuildApiaryMessage;
import com.resourcefulbees.resourcefulbees.network.packets.ValidateApiaryMessage;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import com.resourcefulbees.resourcefulbees.utils.PreviewHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class UnvalidatedApiaryScreen
extends ContainerScreen<UnvalidatedApiaryContainer> {
    private static final ResourceLocation unvalidatedTexture = new ResourceLocation("resourcefulbees", "textures/gui/apiary/unvalidated.png");
    private static final ResourceLocation arrowButtonTexture = new ResourceLocation("resourcefulbees", "textures/gui/apiary/arrow_button.png");
    private final ApiaryTileEntity apiaryTileEntity;
    private final PlayerEntity player;
    private int verticalOffset;
    private int horizontalOffset;
    private ArrowButton upButton;
    private ArrowButton downButton;
    private ArrowButton leftButton;
    private ArrowButton rightButton;
    private PreviewButton previewButton;

    public UnvalidatedApiaryScreen(UnvalidatedApiaryContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.player = inv.field_70458_d;
        this.verticalOffset = screenContainer.getApiaryTileEntity().getVerticalOffset();
        this.horizontalOffset = screenContainer.getApiaryTileEntity().getHorizontalOffset();
        this.apiaryTileEntity = ((UnvalidatedApiaryContainer)this.field_147002_h).getApiaryTileEntity();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.getGuiLeft() + 116, this.getGuiTop() + 10, 50, 20, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.validate", (Object[])new Object[0])), onPress -> this.validate()));
        BuildButton buildStructureButton = (BuildButton)this.func_230480_a_((Widget)new BuildButton(this.getGuiLeft() + 116, this.getGuiTop() + 35, 50, 20, new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.build", (Object[])new Object[0])), onPress -> this.build()));
        if (!this.player.func_184812_l_()) {
            buildStructureButton.field_230693_o_ = false;
        }
        this.previewButton = (PreviewButton)this.func_230480_a_((Widget)new PreviewButton(this.getGuiLeft() + 22, this.getGuiTop() + 25, 12, 12, 0, 24, 12, arrowButtonTexture, ((UnvalidatedApiaryContainer)this.field_147002_h).getApiaryTileEntity().isPreviewed(), onPress -> {
            this.setPreviewToggle();
            this.previewSetToggle(this.previewButton.isTriggered());
        }));
        this.previewSetToggle(this.previewButton.isTriggered());
        this.upButton = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.getGuiLeft() + 22, this.getGuiTop() + 12, ArrowButton.Direction.UP, onPress -> this.offsetPosition(Direction.UP)));
        this.downButton = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.getGuiLeft() + 22, this.getGuiTop() + 38, ArrowButton.Direction.DOWN, onPress -> this.offsetPosition(Direction.DOWN)));
        this.leftButton = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.getGuiLeft() + 9, this.getGuiTop() + 25, ArrowButton.Direction.LEFT, onPress -> this.offsetPosition(Direction.LEFT)));
        this.rightButton = (ArrowButton)this.func_230480_a_((Widget)new ArrowButton(this.getGuiLeft() + 35, this.getGuiTop() + 25, ArrowButton.Direction.RIGHT, onPress -> this.offsetPosition(Direction.RIGHT)));
    }

    private void previewSetToggle(boolean toggled) {
        if (!toggled) {
            this.previewButton.setTrigger(false);
        }
        PreviewHandler.setPreview(((UnvalidatedApiaryContainer)this.func_212873_a_()).getPos(), ((UnvalidatedApiaryContainer)this.field_147002_h).getApiaryTileEntity().buildStructureBounds(this.horizontalOffset, this.verticalOffset), toggled);
    }

    private void setPreviewToggle() {
        if (this.previewButton.field_230693_o_) {
            this.previewButton.setTrigger(!this.previewButton.isTriggered());
        }
    }

    private void offsetPosition(Direction direction) {
        this.previewSetToggle(false);
        switch (direction) {
            case UP: {
                ++this.verticalOffset;
                break;
            }
            case DOWN: {
                --this.verticalOffset;
                break;
            }
            case LEFT: {
                --this.horizontalOffset;
                break;
            }
            default: {
                ++this.horizontalOffset;
            }
        }
        this.verticalOffset = MathUtils.clamp(this.verticalOffset, -1, 2);
        this.horizontalOffset = MathUtils.clamp(this.horizontalOffset, -2, 2);
        this.apiaryTileEntity.setVerticalOffset(this.verticalOffset);
        this.apiaryTileEntity.setHorizontalOffset(this.horizontalOffset);
    }

    private void build() {
        this.previewSetToggle(false);
        UnvalidatedApiaryContainer container = (UnvalidatedApiaryContainer)this.func_212873_a_();
        BlockPos pos = container.getPos();
        NetPacketHandler.sendToServer(new BuildApiaryMessage(pos, this.verticalOffset, this.horizontalOffset));
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.apiaryTileEntity != null) {
            this.upButton.field_230693_o_ = this.verticalOffset != 2;
            this.downButton.field_230693_o_ = this.verticalOffset != -1;
            this.leftButton.field_230693_o_ = this.horizontalOffset != -2;
            this.rightButton.field_230693_o_ = this.horizontalOffset != 2;
            this.func_230446_a_(matrix);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            this.func_230459_a_(matrix, mouseX, mouseY);
        }
    }

    private void validate() {
        this.previewSetToggle(false);
        UnvalidatedApiaryContainer container = (UnvalidatedApiaryContainer)this.func_212873_a_();
        BlockPos pos = container.getPos();
        NetPacketHandler.sendToServer(new ValidateApiaryMessage(pos, this.verticalOffset, this.horizontalOffset));
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        Minecraft client = this.field_230706_i_;
        if (client != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(unvalidatedTexture);
            int i = (this.field_230708_k_ - this.field_146999_f) / 2;
            int j = (this.field_230709_l_ - this.field_147000_g) / 2;
            this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, "Offset", 65.0f, 13.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, "Vert.", 75.0f, 26.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, "Horiz.", 75.0f, 39.0f, 0x404040);
        this.drawRightAlignedString(matrix, this.field_230712_o_, String.valueOf(this.verticalOffset), 70, 26, 0x404040);
        this.drawRightAlignedString(matrix, this.field_230712_o_, String.valueOf(this.horizontalOffset), 70, 39, 0x404040);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            break;
        }
    }

    public void drawRightAlignedString(@NotNull MatrixStack matrix, FontRenderer fontRenderer, @NotNull String s, int posX, int posY, int color) {
        fontRenderer.func_238421_b_(matrix, s, (float)(posX - fontRenderer.func_78256_a(s)), (float)posY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class PreviewButton
    extends ImageButton {
        private final ResourceLocation resourceLocation;
        private final int xTexStart;
        private final int yTexStart;
        private final int yDiffText;
        private boolean triggered;

        public PreviewButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, boolean triggered, Button.IPressable onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.triggered = triggered;
            this.xTexStart = xTexStartIn;
            this.yTexStart = yTexStartIn;
            this.yDiffText = yDiffTextIn;
            this.resourceLocation = resourceLocationIn;
        }

        public void func_230431_b_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(this.resourceLocation);
            RenderSystem.disableDepthTest();
            int i = this.yTexStart;
            int j = this.xTexStart;
            if (!this.field_230693_o_) {
                j += 24;
            } else if (this.isTriggered()) {
                j += 12;
                if (this.func_230449_g_()) {
                    i += this.yDiffText;
                }
            } else if (this.func_230449_g_()) {
                i += this.yDiffText;
            }
            PreviewButton.func_238463_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)j, (float)i, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)64, (int)64);
            RenderSystem.enableDepthTest();
        }

        public void func_230443_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
            StringTextComponent s = !this.isTriggered() ? new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.preview.enable", (Object[])new Object[0])) : new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.preview.disable", (Object[])new Object[0]));
            UnvalidatedApiaryScreen.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
        }

        public void setTrigger(boolean triggered) {
            ((UnvalidatedApiaryContainer)UnvalidatedApiaryScreen.this.field_147002_h).getApiaryTileEntity().setPreviewed(triggered);
            this.triggered = triggered;
        }

        public boolean isTriggered() {
            return this.triggered;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class BuildButton
    extends Button {
        public BuildButton(int widthIn, int heightIn, int width, int height, StringTextComponent text, Button.IPressable onPress) {
            super(widthIn, heightIn, width, height, (ITextComponent)text, onPress);
        }

        public void func_230443_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
            if (!this.field_230693_o_) {
                StringTextComponent s = new StringTextComponent(I18n.func_135052_a((String)"gui.resourcefulbees.apiary.button.build.creative", (Object[])new Object[0]));
                UnvalidatedApiaryScreen.this.func_238652_a_(matrix, (ITextComponent)s, mouseX, mouseY);
            }
        }
    }

    private static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

