/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.container.HoneyGeneratorContainer;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyGeneratorTileEntity;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public class HoneyGeneratorScreen
extends ContainerScreen<HoneyGeneratorContainer> {
    private static final int ENERGY_PER_BOTTLE = 250 / HoneyGeneratorTileEntity.HONEY_DRAIN_AMOUNT * HoneyGeneratorTileEntity.ENERGY_FILL_AMOUNT;

    public HoneyGeneratorScreen(HoneyGeneratorContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = new ResourceLocation("resourcefulbees", "textures/gui/generator/honey_gen.png");
        Minecraft client = this.field_230706_i_;
        if (client != null) {
            client.func_110434_K().func_110577_a(texture);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
            int scaledRF = 62 * ((HoneyGeneratorContainer)this.field_147002_h).getEnergy() / Math.max(((HoneyGeneratorContainer)this.field_147002_h).getMaxEnergy(), 1);
            this.func_238474_b_(matrix, i + 130, j + 12 + (62 - scaledRF), 215, 62 - scaledRF, 11, scaledRF);
            int scaledTank = 62 * ((HoneyGeneratorContainer)this.field_147002_h).getFluidAmount() / Math.max(((HoneyGeneratorContainer)this.field_147002_h).getMaxFluid(), 1);
            this.func_238474_b_(matrix, i + 83, j + 12 + (62 - scaledTank), 226, 62 - scaledTank, 14, scaledTank);
            int scaledProgressX = 21 * ((HoneyGeneratorContainer)this.field_147002_h).getTime() / Math.max(250, 1);
            int scaledProgressY = 20 * ((HoneyGeneratorContainer)this.field_147002_h).getTime() / Math.max(250, 1);
            int energyScaledProgressX = 21 * ((HoneyGeneratorContainer)this.field_147002_h).getEnergyTime() / Math.max(ENERGY_PER_BOTTLE, 1);
            this.func_238474_b_(matrix, i + 35, j + 37, 176, 0, 18, scaledProgressY);
            this.func_238474_b_(matrix, i + 57, j + 42, 194, 0, scaledProgressX, 10);
            this.func_238474_b_(matrix, i + 103, j + 42, 194, 0, energyScaledProgressX, 10);
        }
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (((HoneyGeneratorContainer)this.field_147002_h).getHoneyGeneratorTileEntity() != null) {
            this.func_230446_a_(matrix);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            this.func_230459_a_(matrix, mouseX, mouseY);
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            this.renderFluidTooltip(matrix, mouseX, mouseY, decimalFormat);
            this.renderEnergyTooltip(matrix, mouseX, mouseY, decimalFormat);
        }
    }

    public void renderEnergyTooltip(@NotNull MatrixStack matrix, int mouseX, int mouseY, DecimalFormat decimalFormat) {
        if (MathUtils.inRangeInclusive(mouseX, this.field_147003_i + 130, this.field_147003_i + 141) && MathUtils.inRangeInclusive(mouseY, this.field_147009_r + 12, this.field_147009_r + 74)) {
            if (Screen.func_231173_s_() || ((HoneyGeneratorContainer)this.field_147002_h).getEnergy() < 500) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((HoneyGeneratorContainer)this.field_147002_h).getEnergy() + " RF"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(decimalFormat.format((double)((HoneyGeneratorContainer)this.field_147002_h).getEnergy() / 1000.0) + " kRF"), mouseX, mouseY);
            }
        }
    }

    public void renderFluidTooltip(@NotNull MatrixStack matrix, int mouseX, int mouseY, DecimalFormat decimalFormat) {
        if (MathUtils.inRangeInclusive(mouseX, this.field_147003_i + 83, this.field_147003_i + 97) && MathUtils.inRangeInclusive(mouseY, this.field_147009_r + 12, this.field_147009_r + 74)) {
            if (Screen.func_231173_s_() || ((HoneyGeneratorContainer)this.field_147002_h).getFluidAmount() < 500) {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(((HoneyGeneratorContainer)this.field_147002_h).getFluidAmount() + " MB"), mouseX, mouseY);
            } else {
                this.func_238652_a_(matrix, (ITextComponent)new StringTextComponent(decimalFormat.format((double)((HoneyGeneratorContainer)this.field_147002_h).getFluidAmount() / 1000.0) + " Buckets"), mouseX, mouseY);
            }
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.field_230704_d_.getString(), 8.0f, 5.0f, 0x404040);
    }
}

