/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.EnderBeeconContainer;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.UpdateBeeconMessage;
import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EnderBeeconScreen
extends ContainerScreen<EnderBeeconContainer> {
    private final EnderBeeconTileEntity tileEntity;
    private static final ITextComponent primaryLabel = new TranslationTextComponent("block.resourcefulbees.ender_beecon.primary");
    private static final ITextComponent drainLabel = new TranslationTextComponent("block.resourcefulbees.ender_beecon.drain");
    private static final ITextComponent rangeLabel = new TranslationTextComponent("block.resourcefulbees.ender_beecon.range");
    private static final ITextComponent activeLabel = new TranslationTextComponent("block.resourcefulbees.ender_beecon.is_active");
    private static final ResourceLocation BUTTON_CALMING = new ResourceLocation("resourcefulbees", "textures/gui/ender_beecon/calming_button.png");
    List<PowerButton> powerButtons = new LinkedList<PowerButton>();

    public EnderBeeconScreen(EnderBeeconContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.tileEntity = screenContainer.getEnderBeeconTileEntity();
        this.preInit();
    }

    private void preInit() {
        this.field_146999_f = 230;
        this.field_147000_g = 200;
        this.field_238744_r_ = 36;
        this.field_238745_s_ = 106;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = new ResourceLocation("resourcefulbees", "textures/gui/ender_beecon/ender_beecon.png");
        if (this.field_230706_i_ != null && this.tileEntity != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(texture);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.drawFluidTank(matrix);
        this.drawButtons();
    }

    private void drawButtons() {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int buttonX = i + 24;
        int buttonY = j + 36;
        int buttonWidth = 22;
        int padding = 16;
        int buttonStartX = buttonX;
        this.powerButtons.clear();
        for (EnderBeeconTileEntity.BeeconEffect effect : this.tileEntity.getEffects()) {
            PowerButton button = (PowerButton)this.func_230480_a_((Widget)new PowerButton(buttonStartX, buttonY, effect.getEffect(), BUTTON_CALMING));
            button.field_230693_o_ = true;
            button.setSelected(effect.isActive());
            this.powerButtons.add(button);
            buttonStartX += buttonWidth + padding;
        }
    }

    private void drawFluidTank(MatrixStack matrix) {
        if (!this.tileEntity.getFluidTank().isEmpty()) {
            int tankPosX = this.field_147003_i + 207;
            int tankPosY = this.field_147009_r + 30;
            int tankHeight = 62;
            int tankWidth = 14;
            RenderUtils.renderFluid(matrix, this.tileEntity.getFluidTank(), tankPosX, tankPosY, tankWidth, tankHeight, this.func_230927_p_());
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        int buttonX = 35;
        int buttonY = 61;
        int buttonWidth = 22;
        int padding = 16;
        int buttonStartX = buttonX;
        EnderBeeconScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)primaryLabel, (int)92, (int)24, (int)0xE0E0E0);
        this.field_230712_o_.func_243248_b(matrixStack, drainLabel, 13.0f, 90.0f, 0xE0E0E0);
        this.field_230712_o_.func_238421_b_(matrixStack, this.tileEntity.getDrain() + " mb/t", 44.0f, 90.0f, 16751628);
        this.field_230712_o_.func_243248_b(matrixStack, rangeLabel, 90.0f, 90.0f, 0xE0E0E0);
        this.field_230712_o_.func_238421_b_(matrixStack, this.tileEntity.getRange() + " blocks", 125.0f, 90.0f, 34815);
        this.field_230712_o_.func_243248_b(matrixStack, activeLabel, 13.0f, 78.0f, 0xE0E0E0);
        if (this.tileEntity.doEffects()) {
            this.field_230712_o_.func_238421_b_(matrixStack, "Yes", 63.0f, 78.0f, 47104);
        } else {
            this.field_230712_o_.func_238421_b_(matrixStack, "No", 63.0f, 78.0f, 0xBC0000);
        }
        for (PowerButton widget : this.powerButtons) {
            EnderBeeconTileEntity.BeeconEffect effect = this.tileEntity.getEffect(widget.effect);
            if (((Boolean)Config.BEECON_DO_MULTIPLIER.get()).booleanValue()) {
                EnderBeeconScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("x" + effect.getValue()), (int)buttonStartX, (int)buttonY, (int)0xE0E0E0);
            } else {
                EnderBeeconScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("+" + effect.getValue()), (int)buttonStartX, (int)buttonY, (int)0xE0E0E0);
            }
            buttonStartX += buttonWidth + padding;
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrixStack, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        DecimalFormat decimalFormat = new DecimalFormat("##0.0");
        StringTextComponent fluidCount = (float)this.tileEntity.getFluidTank().getFluidAmount() < 1000.0f || Screen.func_231173_s_() ? new StringTextComponent(decimalFormat.format(this.tileEntity.getFluidTank().getFluidAmount()) + " mb") : new StringTextComponent(decimalFormat.format((float)this.tileEntity.getFluidTank().getFluidAmount() / 1000.0f) + " B");
        if (mouseX >= this.field_147003_i + 207 && mouseX <= this.field_147003_i + 221 && mouseY >= this.field_147009_r + 30 && mouseY <= this.field_147009_r + 92) {
            this.func_238652_a_(matrixStack, (ITextComponent)fluidCount, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (((EnderBeeconContainer)this.field_147002_h).getEnderBeeconTileEntity() != null) {
            this.func_230446_a_(matrix);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class PowerButton
    extends Button {
        private final Effect effect;
        private final TextureAtlasSprite effectSprite;
        private final ITextComponent textComponent;

        public PowerButton(int xPos, int yPos, Effect effect, ResourceLocation texture) {
            super(xPos, yPos, texture);
            this.effect = effect;
            this.effectSprite = Minecraft.func_71410_x().func_213248_ap().func_215288_a(effect);
            this.textComponent = this.getTooltip(effect);
        }

        private ITextComponent getTooltip(Effect effect) {
            return new TranslationTextComponent(effect.func_76393_a());
        }

        public void func_230930_b_() {
            NetPacketHandler.sendToServer(new UpdateBeeconMessage(this.effect.getRegistryName(), !this.isSelected(), EnderBeeconScreen.this.tileEntity.func_174877_v()));
            this.setSelected(!this.isSelected());
            EnderBeeconScreen.this.func_231023_e_();
            EnderBeeconScreen.this.func_231160_c_();
        }

        public void func_230443_a_(@NotNull MatrixStack matrixStack, int xPos, int yPos) {
            EnderBeeconScreen.this.func_238652_a_(matrixStack, this.textComponent, xPos, yPos);
        }

        @Override
        protected void renderExtra(MatrixStack matrixStack) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.effectSprite.func_229241_m_().func_229223_g_());
            PowerButton.func_238470_a_((MatrixStack)matrixStack, (int)(this.field_230690_l_ + 2), (int)(this.field_230691_m_ + 2), (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)this.effectSprite);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class Button
    extends AbstractButton {
        private boolean selected;
        private final ResourceLocation texture;

        protected Button(int xPos, int yPos, ResourceLocation texture) {
            super(xPos, yPos, 22, 22, StringTextComponent.field_240750_d_);
            this.texture = texture;
        }

        public void func_230431_b_(@NotNull MatrixStack matrixStack, int xPos, int yPos, float v) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean i = false;
            int j = 0;
            if (!this.field_230693_o_) {
                j += this.field_230688_j_ * 2;
            } else if (this.selected) {
                j += this.field_230688_j_;
            } else if (this.func_230449_g_()) {
                j += this.field_230688_j_ * 3;
            }
            Button.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)j, (float)((float)i), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)88, (int)22);
            this.renderExtra(matrixStack);
        }

        protected abstract void renderExtra(MatrixStack var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

