/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;

public class IncompatibleModWarning {
    private static boolean hasBeenShownOnce;
    private static boolean isPerformantLoaded;

    private IncompatibleModWarning() {
        throw new IllegalStateException("Utility Class");
    }

    public static void init() {
        isPerformantLoaded = FMLLoader.getLoadingModList().getModFileById("performant") != null;
        MinecraftForge.EVENT_BUS.addListener(IncompatibleModWarning::guiOpened);
    }

    private static void guiOpened(GuiOpenEvent event) {
        Screen curr = event.getGui();
        if (isPerformantLoaded && !hasBeenShownOnce && (curr instanceof WorldSelectionScreen || curr instanceof MultiplayerScreen) && Boolean.FALSE.equals(Config.BYPASS_PERFORMANT_CHECK.get())) {
            event.setGui((Screen)new ModWarningScreen(curr));
            hasBeenShownOnce = true;
        }
    }

    private static class ModWarningScreen
    extends Screen {
        private final Screen parent;
        private int ticksElapsed = 0;

        protected ModWarningScreen(Screen parent) {
            super((ITextComponent)new StringTextComponent(""));
            this.parent = parent;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
        }

        public void func_231023_e_() {
            super.func_231023_e_();
            ++this.ticksElapsed;
        }

        public void func_230430_a_(@NotNull MatrixStack stack, int mx, int my, float partialTicks) {
            super.func_230430_a_(stack, mx, my, partialTicks);
            this.func_231165_f_(0);
            int middle = this.field_230708_k_ / 2;
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"Performant is incompatible with Resourceful Bees", (int)middle, (int)62, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"This is a known issue with performant and it breaking other mods, the author does not care", (int)middle, (int)74, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"GitHub issue on the matter: https://github.com/someaddons/performant_issues/issues/70", (int)middle, (int)86, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"To bypass this check set \"bypassPerformantCheck: true\" in your Resourceful Bees common.toml config", (int)middle, (int)98, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"If you bypass this check we will not provide any support for", (int)middle, (int)110, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"any issues related to Resourceful Bees or the mods that use it", (int)middle, (int)122, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"If you believe your issue is unrelated, disable performant and reproduce it", (int)middle, (int)134, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"By choosing to bypass this check you understand that here there be dragons", (int)middle, (int)146, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"Press ESC if you would like to close this screen.", (int)middle, (int)158, (int)0xFFFFFF);
            ModWarningScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)("This will auto close in: " + (1800 - this.ticksElapsed) / 20 + "s"), (int)middle, (int)170, (int)0xFFFFFF);
            if (this.ticksElapsed > 1800) {
                Minecraft.func_71410_x().func_147108_a(this.parent);
            }
        }

        public boolean func_231046_a_(int keycode, int scanCode, int modifiers) {
            if (keycode == 256) {
                Minecraft.func_71410_x().func_147108_a(this.parent);
            }
            return super.func_231046_a_(keycode, scanCode, modifiers);
        }
    }
}

