/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.capabilities;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class MultiFluidTank
implements IFluidHandler {
    protected FluidTank[] fluidTanks;

    public MultiFluidTank(int capacity, int numberOfTanks) {
        this(capacity, numberOfTanks, fluidStack -> true);
    }

    public MultiFluidTank(int capacity, int numberOfTanks, Predicate<FluidStack> validator) {
        this.fluidTanks = new FluidTank[numberOfTanks];
        for (int i = 0; i < numberOfTanks; ++i) {
            this.fluidTanks[i] = new FluidTank(capacity, validator);
        }
    }

    public int getTanks() {
        return this.fluidTanks.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidTanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidTanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.fluidTanks[tank].isFluidValid(stack);
    }

    public int getFluidAmountInTank(int tank) {
        return this.fluidTanks[tank].getFluidAmount();
    }

    public void setFluidInTank(int tank, FluidStack fluidStack) {
        this.fluidTanks[tank].setFluid(fluidStack);
    }

    @Deprecated
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public int fill(int tank, FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidTanks[tank].fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (FluidTank fluidTank : this.fluidTanks) {
            if (!resource.isFluidEqual(fluidTank.getFluid())) continue;
            return fluidTank.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        Optional<FluidTank> largestTank = Arrays.stream(this.fluidTanks).max(Comparator.comparingInt(FluidTank::getFluidAmount));
        return largestTank.map(fluidTank -> fluidTank.drain(maxDrain, action)).orElse(FluidStack.EMPTY);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action, int tank) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.fluidTanks[tank].drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action, int tank) {
        if (this.fluidTanks[tank].getFluidAmount() > 0) {
            return this.fluidTanks[tank].drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public void readFromNBT(CompoundNBT nbt) {
        ListNBT listNBT = nbt.func_150295_c("Tanks", 10);
        if (!listNBT.isEmpty()) {
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundNBT tank = listNBT.func_150305_b(i);
                this.fluidTanks[i].readFromNBT(tank);
            }
        }
    }

    public ListNBT writeToNBT() {
        ListNBT listNBT = new ListNBT();
        int i = 0;
        for (FluidTank fluidTank : this.fluidTanks) {
            listNBT.add(i++, (INBT)fluidTank.writeToNBT(new CompoundNBT()));
        }
        return listNBT;
    }
}

