/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block.multiblocks.centrifuge;

import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.CentrifugeTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge.CentrifugeControllerTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CentrifugeControllerBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty PROPERTY_VALID = BooleanProperty.func_177716_a((String)"valid");

    public CentrifugeControllerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_VALID, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected CentrifugeControllerTileEntity getControllerEntity(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CentrifugeControllerTileEntity) {
            return (CentrifugeControllerTileEntity)tileEntity;
        }
        return null;
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        boolean hasCapability = heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        CentrifugeControllerTileEntity controller = this.getControllerEntity(world, pos);
        if (controller != null && controller.isValidStructure()) {
            if (hasCapability) {
                controller.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(iFluidHandler -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, null));
            } else if (!player.func_225608_bj_() && !world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)controller, (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    public void func_220069_a(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull Block changedBlock, @NotNull BlockPos changedBlockPos, boolean bool) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CentrifugeTileEntity) {
            CentrifugeTileEntity centrifugeTileEntity = (CentrifugeTileEntity)tileEntity;
            centrifugeTileEntity.setIsPoweredByRedstone(world.func_175640_z(pos));
        }
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@NotNull BlockState state, @NotNull World worldIn, @NotNull BlockPos pos) {
        return this.getControllerEntity(worldIn, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CentrifugeControllerTileEntity((TileEntityType)ModTileEntityTypes.CENTRIFUGE_CONTROLLER_ENTITY.get());
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_VALID, FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.centrifuge.tooltip.info", (Object[])new Object[0]), TextFormatting.GOLD).build());
        if (Screen.func_231172_r_()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.centrifuge.tooltip.structure_size", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.centrifuge.tooltip.requisites", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.centrifuge.tooltip.capabilities", (Object[])new Object[0]), TextFormatting.AQUA).build());
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + I18n.func_135052_a((String)"resourcefulbees.ctrl_info", (Object[])new Object[0])));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

