/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.item.UpgradeItem;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.tileentity.TieredBeehiveTileEntity;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TieredBeehiveBlock
extends BeehiveBlock {
    private static final String SHEARS_TAG = "forge:shears";
    public static final IntegerProperty TIER_PROPERTY = IntegerProperty.func_177719_a((String)"tier", (int)0, (int)4);
    private final int tier;
    private final float tierModifier;

    public TieredBeehiveBlock(int tier, float tierModifier, AbstractBlock.Properties properties) {
        super(properties);
        this.tier = tier;
        this.tierModifier = tierModifier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_226873_c_, (Comparable)Integer.valueOf(0))).func_206870_a((Property)field_226872_b_, (Comparable)Direction.NORTH)).func_206870_a((Property)TIER_PROPERTY, (Comparable)Integer.valueOf(tier)));
    }

    public static boolean dropResourceHoneycomb(TieredBeehiveBlock block, World world, BlockPos pos, boolean useScraper) {
        return block.dropResourceHoneycomb(world, pos, useScraper);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction;
        Direction direction2 = direction = context.func_195999_j() != null && context.func_195999_j().func_225608_bj_() ? context.func_195992_f() : context.func_195992_f().func_176734_d();
        if (context.func_195996_i().func_77978_p() != null) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_226872_b_, (Comparable)direction)).func_206870_a((Property)TIER_PROPERTY, (Comparable)Integer.valueOf(context.func_195996_i().func_77978_p().func_74775_l("BlockEntityTag").func_74762_e("Tier")));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_226872_b_, (Comparable)direction)).func_206870_a((Property)TIER_PROPERTY, (Comparable)Integer.valueOf(this.tier));
    }

    @Nullable
    public TileEntity func_196283_a_(@NotNull IBlockReader reader) {
        return null;
    }

    public boolean isHiveSmoked(BlockPos pos, World world) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TieredBeehiveTileEntity && ((TieredBeehiveTileEntity)tileEntity).func_226972_k_();
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, PlayerEntity player, @NotNull Hand handIn, @NotNull BlockRayTraceResult hit) {
        ActionResultType success;
        ItemStack itemstack = player.func_184586_b(handIn);
        if ((Integer)state.func_177229_b((Property)field_226873_c_) >= 5) {
            ActionResultType success2;
            boolean isShear = (Boolean)Config.ALLOW_SHEARS.get() != false && itemstack.func_77973_b().func_206844_a(BeeInfoUtils.getItemTag(SHEARS_TAG));
            boolean isScraper = itemstack.func_77973_b().equals(ModItems.SCRAPER.get());
            if ((isShear || isScraper) && (success2 = this.performHoneyHarvest(state, world, pos, player, handIn, itemstack, isScraper)) != null) {
                return success2;
            }
        }
        if (UpgradeItem.isUpgradeItem(itemstack) && UpgradeItem.getUpgradeType(itemstack).equals("hiveUpgrade") && (success = this.performHiveUpgrade(state, world, pos, itemstack)) != null) {
            return success;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    private ActionResultType performHiveUpgrade(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, ItemStack itemstack) {
        TieredBeehiveTileEntity beehiveTileEntity;
        CompoundNBT data = ((UpgradeItem)itemstack.func_77973_b()).getUpgradeData();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TieredBeehiveTileEntity && 1 + (beehiveTileEntity = (TieredBeehiveTileEntity)tileEntity).getTier() == data.func_74762_e("Tier")) {
            int newTier = data.func_74762_e("Tier");
            beehiveTileEntity.setTier(newTier);
            beehiveTileEntity.setTierModifier(data.func_74760_g("TierModifier"));
            beehiveTileEntity.recalculateHoneyLevel();
            itemstack.func_190918_g(1);
            state = (BlockState)state.func_206870_a((Property)TIER_PROPERTY, (Comparable)Integer.valueOf(newTier));
            world.func_175656_a(pos, state);
            return ActionResultType.SUCCESS;
        }
        return null;
    }

    @Nullable
    private ActionResultType performHoneyHarvest(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, PlayerEntity player, @NotNull Hand handIn, ItemStack itemstack, boolean isScraper) {
        TieredBeehiveTileEntity beehiveTileEntity;
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        this.dropResourceHoneycomb(world, pos, isScraper);
        itemstack.func_222118_a(1, (LivingEntity)player, player1 -> player1.func_213334_d(handIn));
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TieredBeehiveTileEntity && !(beehiveTileEntity = (TieredBeehiveTileEntity)tileEntity).hasCombs()) {
            if (this.isHiveSmoked(pos, world)) {
                this.func_226876_a_(world, state, pos);
            } else {
                if (beehiveTileEntity.hasBees() && !(player instanceof FakePlayer)) {
                    this.angerBeesNearby(world, pos);
                }
                this.func_226877_a_(world, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
            }
            return ActionResultType.SUCCESS;
        }
        return null;
    }

    private void angerBeesNearby(World world, BlockPos pos) {
        List playerEntityList;
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72314_b(8.0, 6.0, 8.0);
        List beeEntityList = world.func_217357_a(BeeEntity.class, aabb);
        if (!beeEntityList.isEmpty() && !(playerEntityList = world.func_217357_a(PlayerEntity.class, aabb)).isEmpty()) {
            beeEntityList.stream().filter(beeEntity -> beeEntity.func_70638_az() == null).forEach(beeEntity -> {
                PlayerEntity randomPlayer = (PlayerEntity)playerEntityList.get(world.field_73012_v.nextInt(playerEntityList.size()));
                if (!(randomPlayer instanceof FakePlayer)) {
                    beeEntity.func_70624_b((LivingEntity)randomPlayer);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            this.createAdvancedTooltip(stack, tooltip);
        } else {
            this.createNormalTooltip(tooltip, stack);
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    private void createNormalTooltip(@NotNull List<ITextComponent> tooltip, ItemStack stack) {
        CompoundNBT stackTag;
        int localTier = this.tier;
        float localTierModifier = this.tierModifier;
        if (stack.func_77942_o() && (stackTag = stack.func_77978_p()) != null && !stackTag.isEmpty() && stackTag.func_74764_b("BlockEntityTag")) {
            CompoundNBT blockEntityTag = stackTag.func_74775_l("BlockEntityTag");
            localTier = blockEntityTag.func_74762_e("Tier");
            localTierModifier = blockEntityTag.func_74760_g("TierModifier");
        }
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"resourcefulbees.shift_info", (Object[])new Object[0])));
        tooltip.addAll(new TooltipBuilder().addTranslatableTip("gui.resourcefulbees.beehive.tier").appendText(String.valueOf(localTier)).applyStyle(TextFormatting.GOLD).addTranslatableTip("block.resourcefulbees.beehive.tooltip.max_bees").appendText(" " + Math.round((float)((Integer)Config.HIVE_MAX_BEES.get()).intValue() * localTierModifier)).applyStyle(TextFormatting.GOLD).addTranslatableTip("block.resourcefulbees.beehive.tooltip.max_combs").appendText(" " + Math.round((float)((Integer)Config.HIVE_MAX_COMBS.get()).intValue() * localTierModifier)).applyStyle(TextFormatting.GOLD).build());
        if (localTier != 1) {
            int timeReduction = localTier > 1 ? (int)((double)localTier * 0.05 * 100.0) : 5;
            String sign = localTier > 1 ? "-" : "+";
            tooltip.addAll(new TooltipBuilder().addTranslatableTip("block.resourcefulbees.beehive.tooltip.hive_time").appendText(" " + sign + timeReduction + "%").applyStyle(TextFormatting.GOLD).build());
        }
    }

    private void createAdvancedTooltip(@NotNull ItemStack stack, @NotNull List<ITextComponent> tooltip) {
        if (stack.func_77942_o()) {
            CompoundNBT stackTag = stack.func_77978_p();
            if (stackTag != null && !stackTag.isEmpty() && stackTag.func_74764_b("BlockEntityTag")) {
                CompoundNBT blockEntityTag = stackTag.func_74775_l("BlockEntityTag");
                this.createBeesTooltip(tooltip, blockEntityTag);
                this.createHoneycombsTooltip(tooltip, blockEntityTag);
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.resourcefulbees.beehive.tooltip.bees").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.RESET}));
            tooltip.add((ITextComponent)new TranslationTextComponent("block.resourcefulbees.beehive.tooltip.honeycombs").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.RESET}));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_226873_c_, field_226872_b_, TIER_PROPERTY});
    }

    private void createHoneycombsTooltip(@NotNull List<ITextComponent> tooltip, CompoundNBT blockEntityTag) {
        if (blockEntityTag.func_150297_b("Honeycombs", 9)) {
            HashMap<String, Integer> combs = new HashMap<String, Integer>();
            tooltip.add((ITextComponent)new TranslationTextComponent("block.resourcefulbees.beehive.tooltip.honeycombs").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.RESET}));
            ListNBT combList = blockEntityTag.func_150295_c("Honeycombs", 10);
            for (int i = 0; i < combList.size(); ++i) {
                String id = combList.func_150305_b(i).func_74779_i("id");
                String comb2 = id.substring(id.indexOf(":") + 1).replace("_", " ");
                combs.merge(comb2, 1, Integer::sum);
            }
            combs.forEach((comb, count) -> tooltip.add((ITextComponent)new StringTextComponent("     ").func_240702_b_(String.valueOf(count)).func_240702_b_("x ").func_240702_b_(WordUtils.capitalize((String)comb))));
        }
    }

    private void createBeesTooltip(@NotNull List<ITextComponent> tooltip, CompoundNBT blockEntityTag) {
        if (blockEntityTag.func_150297_b("Bees", 9)) {
            HashMap<String, Integer> bees = new HashMap<String, Integer>();
            tooltip.add((ITextComponent)new TranslationTextComponent("block.resourcefulbees.beehive.tooltip.bees").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.RESET}));
            ListNBT beeList = blockEntityTag.func_150295_c("Bees", 10);
            for (int i = 0; i < beeList.size(); ++i) {
                CompoundNBT entityData = beeList.func_150305_b(i).func_74775_l("EntityData");
                String id = entityData.func_74779_i("id");
                String beeType = id.substring(id.indexOf(":") + 1).replace("_", " ");
                if (beeType.length() == 3 && beeType.matches("Bee")) {
                    bees.merge("Minecraft Bee", 1, Integer::sum);
                    continue;
                }
                bees.merge(beeType, 1, Integer::sum);
            }
            bees.forEach((name, count) -> tooltip.add((ITextComponent)new StringTextComponent("     ").func_240702_b_(String.valueOf(count)).func_240702_b_("x ").func_240702_b_(WordUtils.capitalize((String)name))));
        }
    }

    public boolean dropResourceHoneycomb(World world, BlockPos pos, boolean useScraper) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof TieredBeehiveTileEntity) {
            TieredBeehiveTileEntity hive = (TieredBeehiveTileEntity)blockEntity;
            while (hive.hasCombs()) {
                TieredBeehiveBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)hive.getResourceHoneycomb());
                if (!useScraper) continue;
            }
            return !hive.hasCombs();
        }
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TieredBeehiveTileEntity(this.tier, this.tierModifier);
    }
}

