/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneycombBlock
extends Block {
    protected final ColorData colorData;
    protected final String beeType;

    public HoneycombBlock(String beeType, ColorData colorData, AbstractBlock.Properties properties) {
        super(properties);
        this.colorData = colorData;
        this.beeType = beeType;
    }

    public int getHoneycombColor() {
        return this.colorData.getHoneycombColorInt();
    }

    public String getBeeType() {
        return this.beeType;
    }

    public static int getBlockColor(BlockState state, @Nullable IBlockReader world, @Nullable BlockPos pos, int tintIndex) {
        HoneycombBlock honeycombBlock = (HoneycombBlock)state.func_177230_c();
        return honeycombBlock.colorData.isRainbowBee() ? RainbowColor.getRGB() : honeycombBlock.getHoneycombColor();
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        BlockItem blockItem = (BlockItem)stack.func_77973_b();
        HoneycombBlock honeycombBlock = (HoneycombBlock)blockItem.func_179223_d();
        return honeycombBlock.colorData.isRainbowBee() ? RainbowColor.getRGB() : honeycombBlock.getHoneycombColor();
    }

    @NotNull
    public List<ItemStack> func_220076_a(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        drops.add(((Item)BeeRegistry.getRegistry().getBeeData(this.beeType).getCombBlockItemRegistryObject().get()).func_190903_i());
        return drops;
    }

    public void func_180655_c(@NotNull BlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        if (this.colorData.isRainbowBee()) {
            world.func_184138_a(pos, stateIn, stateIn, 2);
        }
        super.func_180655_c(stateIn, world, pos, rand);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ((Item)BeeRegistry.getRegistry().getBeeData(this.beeType).getCombBlockItemRegistryObject().get()).func_190903_i();
    }
}

