/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.block.CentrifugeBlock;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyGeneratorTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyGenerator
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty PROPERTY_ON = BooleanProperty.func_177716_a((String)"on");

    public HoneyGenerator(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_ON, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof HoneyGeneratorTileEntity) {
            CentrifugeBlock.capabilityOrGuiUse(tileEntity, player, world, pos, hand);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@NotNull BlockState state, World worldIn, @NotNull BlockPos pos) {
        return (INamedContainerProvider)worldIn.func_175625_s(pos);
    }

    public void func_196243_a(@NotNull BlockState state1, World world, @NotNull BlockPos pos, @NotNull BlockState state, boolean isMoving) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof HoneyGeneratorTileEntity && state.func_177230_c() != state1.func_177230_c()) {
            HoneyGeneratorTileEntity honeyGeneratorTileEntity = (HoneyGeneratorTileEntity)blockEntity;
            HoneyGeneratorTileEntity.TileStackHandler h = honeyGeneratorTileEntity.getTileStackHandler();
            IntStream.range(0, h.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)h).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        }
        super.func_196243_a(state1, world, pos, state, isMoving);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HoneyGeneratorTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_ON, FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.generator.tooltip.info", (Object[])new Object[0]), TextFormatting.GOLD).build());
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

