/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.block.HoneyTank;
import com.resourcefulbees.resourcefulbees.registry.ModTileEntityTypes;
import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyTankTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderBeecon
extends HoneyTank {
    protected static final VoxelShape VOXEL_SHAPE_TOP = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final AbstractBlock.Properties PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151678_z).func_235861_h_().harvestTool(ToolType.PICKAXE).func_200943_b(5.0f).harvestLevel(2).func_200947_a(SoundType.field_235596_R_).func_235838_a_(luminance -> 15).func_226896_b_().func_208770_d();

    public EnderBeecon(AbstractBlock.Properties properties) {
        super(properties, HoneyTankTileEntity.TankTier.NETHER);
        BlockState defaultState = (BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    @Override
    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        boolean usingHoney = heldItem.func_77973_b() instanceof HoneyBottleItem;
        boolean usingBottle = heldItem.func_77973_b() instanceof GlassBottleItem;
        boolean hasCapability = heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        boolean usingWool = heldItem.func_77973_b().func_206844_a((ITag)ItemTags.createOptional((ResourceLocation)new ResourceLocation("minecraft", "wool")));
        boolean usingStick = heldItem.func_77973_b() == Items.field_151055_y;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EnderBeeconTileEntity) {
            EnderBeeconTileEntity beecon = (EnderBeeconTileEntity)tileEntity;
            if (!world.field_72995_K) {
                if (usingWool) {
                    beecon.toggleSound();
                } else if (usingStick) {
                    beecon.toggleBeam();
                } else if (hasCapability) {
                    tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(iFluidHandler -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, null));
                } else if (usingBottle) {
                    beecon.fillBottle(player, hand);
                } else if (usingHoney) {
                    beecon.emptyBottle(player, hand);
                } else if (!player.func_225608_bj_()) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)pos);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderBeeconTileEntity((TileEntityType)ModTileEntityTypes.ENDER_BEECON_TILE_ENTITY.get());
    }

    @Override
    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return VOXEL_SHAPE_TOP;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.addAll(new TooltipBuilder().addTranslatableTip("block.resourcefulbees.beecon.tooltip.info", TextFormatting.LIGHT_PURPLE).addTranslatableTip("block.resourcefulbees.beecon.tooltip.info.1", TextFormatting.LIGHT_PURPLE).build());
        if (!stack.func_77942_o() || stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || !stack.func_77978_p().func_74764_b("fluid")) {
            return;
        }
        FluidTank tank = new FluidTank(16000).readFromNBT(stack.func_77978_p().func_74775_l("fluid"));
        FluidStack fluid = tank.getFluid();
        if (!fluid.isEmpty()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)fluid.getTranslationKey(), (Object[])new Object[0])).appendText(": [" + tank.getFluidAmount() + "/" + tank.getCapacity() + "]").applyStyle(TextFormatting.GOLD).build());
        }
    }

    @Override
    public void func_180633_a(World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable LivingEntity livingEntity, @NotNull ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EnderBeeconTileEntity) {
            EnderBeeconTileEntity tank = (EnderBeeconTileEntity)tileEntity;
            if (itemStack.func_77978_p() != null) {
                tank.readNBT(itemStack.func_77978_p());
            }
        }
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof EnderBeeconTileEntity) {
            EnderBeeconTileEntity tank = (EnderBeeconTileEntity)tileEntity;
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
            stack.func_77982_d(tank.writeNBT(new CompoundNBT()));
            return stack;
        }
        return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
    }
}

