/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.honeydata;

import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyEffect;
import com.resourcefulbees.resourcefulbees.registry.ItemGroupResourcefulBees;
import com.resourcefulbees.resourcefulbees.utils.color.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HoneyBottleData {
    public static final Logger LOGGER = LogManager.getLogger();
    private String name = null;
    private int hunger = 1;
    private float saturation = 1.0f;
    private String honeyColor = "#FFFFFF";
    private boolean isRainbow = false;
    private boolean generateHoneyBlock = true;
    private boolean honeyBlockRecipe = true;
    private boolean generateHoneyFluid = true;
    private List<HoneyEffect> effects;
    private transient RegistryObject<Item> honeyBottleRegistryObject;
    private transient RegistryObject<Item> honeyBlockItemRegistryObject;
    private transient RegistryObject<Block> honeyBlockRegistryObject;
    private transient RegistryObject<FlowingFluid> honeyStillFluidRegistryObject;
    private transient RegistryObject<FlowingFluid> honeyFlowingFluidRegistryObject;
    private transient RegistryObject<Item> honeyBucketItemRegistryObject;
    private transient RegistryObject<FlowingFluidBlock> honeyFluidBlockRegistryObject;
    private transient boolean shouldResourcefulBeesDoForgeRegistration;

    public HoneyBottleData() {
    }

    public HoneyBottleData(String name, int hunger, float saturation, String honeyColor, boolean isRainbow, boolean generateHoneyBlock, boolean generateHoneyFluid, boolean honeyBlockRecipe, List<HoneyEffect> effects) {
        this.name = name;
        this.hunger = hunger;
        this.saturation = saturation;
        this.honeyColor = honeyColor;
        this.isRainbow = isRainbow;
        this.generateHoneyBlock = generateHoneyBlock;
        this.generateHoneyFluid = generateHoneyFluid;
        this.honeyBlockRecipe = honeyBlockRecipe;
        this.effects = effects;
    }

    public int getHoneyColorInt() {
        return Color.parseInt(this.honeyColor);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasHoneyColor() {
        return this.honeyColor != null && !this.honeyColor.isEmpty();
    }

    public String getHoneyColor() {
        return this.honeyColor == null ? "#ffffff" : this.honeyColor;
    }

    public int getHunger() {
        return this.hunger;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public boolean isRainbow() {
        return this.isRainbow;
    }

    public List<HoneyEffect> getEffects() {
        return this.effects == null ? new ArrayList() : this.effects;
    }

    public void setHoneyBottleRegistryObject(RegistryObject<Item> honeyBottleRegistryObject) {
        this.honeyBottleRegistryObject = this.honeyBottleRegistryObject == null ? honeyBottleRegistryObject : this.honeyBottleRegistryObject;
    }

    public void setHoneyBlockItemRegistryObject(RegistryObject<Item> honeyBlockItemRegistryObject) {
        this.honeyBlockItemRegistryObject = this.honeyBlockItemRegistryObject == null ? honeyBlockItemRegistryObject : this.honeyBlockItemRegistryObject;
    }

    public void setHoneyBlockRegistryObject(RegistryObject<Block> honeyBlockRegistryObject) {
        this.honeyBlockRegistryObject = this.honeyBlockRegistryObject == null ? honeyBlockRegistryObject : this.honeyBlockRegistryObject;
    }

    public void setHoneyStillFluidRegistryObject(RegistryObject<FlowingFluid> honeyStillFluidRegistryObject) {
        this.honeyStillFluidRegistryObject = this.honeyStillFluidRegistryObject == null ? honeyStillFluidRegistryObject : this.honeyStillFluidRegistryObject;
    }

    public void setHoneyFlowingFluidRegistryObject(RegistryObject<FlowingFluid> honeyFlowingFluidRegistryObject) {
        this.honeyFlowingFluidRegistryObject = this.honeyFlowingFluidRegistryObject == null ? honeyFlowingFluidRegistryObject : this.honeyFlowingFluidRegistryObject;
    }

    public void setHoneyBucketItemRegistryObject(RegistryObject<Item> honeyBucketItemRegistryObject) {
        this.honeyBucketItemRegistryObject = this.honeyBucketItemRegistryObject == null ? honeyBucketItemRegistryObject : this.honeyBucketItemRegistryObject;
    }

    public void setHoneyFluidBlockRegistryObject(RegistryObject<FlowingFluidBlock> honeyFluidBlockRegistryObject) {
        this.honeyFluidBlockRegistryObject = this.honeyFluidBlockRegistryObject == null ? honeyFluidBlockRegistryObject : this.honeyFluidBlockRegistryObject;
    }

    public RegistryObject<Item> getHoneyBottleRegistryObject() {
        return this.honeyBottleRegistryObject;
    }

    public RegistryObject<Item> getHoneyBlockItemRegistryObject() {
        return this.honeyBlockItemRegistryObject;
    }

    public RegistryObject<Block> getHoneyBlockRegistryObject() {
        return this.honeyBlockRegistryObject;
    }

    public RegistryObject<FlowingFluid> getHoneyStillFluidRegistryObject() {
        return this.honeyStillFluidRegistryObject;
    }

    public RegistryObject<FlowingFluid> getHoneyFlowingFluidRegistryObject() {
        return this.honeyFlowingFluidRegistryObject;
    }

    public RegistryObject<Item> getHoneyBucketItemRegistryObject() {
        return this.honeyBucketItemRegistryObject;
    }

    public RegistryObject<FlowingFluidBlock> getHoneyFluidBlockRegistryObject() {
        return this.honeyFluidBlockRegistryObject;
    }

    public Item.Properties getProperties() {
        return new Item.Properties().func_200916_a(ItemGroupResourcefulBees.RESOURCEFUL_BEES).func_200919_a(Items.field_151069_bo).func_200917_a(16);
    }

    public Food getFood() {
        Food.Builder builder = new Food.Builder().func_221456_a(this.hunger).func_221454_a(this.saturation);
        if (this.hasEffects()) {
            for (HoneyEffect honeyEffect : this.effects) {
                builder.effect(honeyEffect::getInstance, honeyEffect.chance);
            }
        }
        return builder.func_221453_d();
    }

    private boolean hasEffects() {
        return this.effects != null && !this.effects.isEmpty();
    }

    public boolean doGenerateHoneyBlock() {
        return this.generateHoneyBlock;
    }

    public boolean doGenerateHoneyFluid() {
        return this.generateHoneyFluid;
    }

    public boolean doHoneyBlockRecipe() {
        return this.honeyBlockRecipe;
    }

    public void setEffects(List<HoneyEffect> effects) {
        this.effects = effects;
    }

    public boolean shouldResourcefulBeesDoForgeRegistration() {
        return this.shouldResourcefulBeesDoForgeRegistration;
    }

    public void setShouldResourcefulBeesDoForgeRegistration(boolean shouldResourcefulBeesDoForgeRegistration) {
        this.shouldResourcefulBeesDoForgeRegistration = shouldResourcefulBeesDoForgeRegistration;
    }

    public TranslationTextComponent getFluidTranslation() {
        return new TranslationTextComponent(String.format("fluid.resourcefulbees.%s_honey", this.name));
    }

    public TranslationTextComponent getBottleTranslation() {
        return new TranslationTextComponent(String.format("item.resourcefulbees.%s_honey_bottle", this.name));
    }

    public TranslationTextComponent getBlockTranslation() {
        return new TranslationTextComponent(String.format("block.resourcefulbees.%s_honey_block", this.name));
    }

    public TranslationTextComponent getBucketTranslation() {
        return new TranslationTextComponent(String.format("item.resourcefulbees.%s_honey_fluid_bucket", this.name));
    }

    public static class Builder {
        private String name;
        private int hunger;
        private float saturation;
        private String honeyColor;
        private boolean isRainbow = false;
        private boolean generateHoneyBlock = true;
        private boolean honeyBlockRecipe = true;
        private boolean generateHoneyFluid = true;
        private final List<HoneyEffect> effects = new ArrayList<HoneyEffect>();

        public Builder(String name, int hunger, float saturation, String honeyColor) {
            this.name = name;
            this.hunger = hunger;
            this.saturation = saturation;
            this.honeyColor = honeyColor;
        }

        public Builder setRainbow(boolean rainbow) {
            this.isRainbow = rainbow;
            return this;
        }

        public Builder setGenerateHoneyBlock(boolean generateHoneyBlock) {
            this.generateHoneyBlock = generateHoneyBlock;
            return this;
        }

        public Builder setHoneyBlockRecipe(boolean honeyBlockRecipe) {
            this.honeyBlockRecipe = honeyBlockRecipe;
            return this;
        }

        public Builder setGenerateHoneyFluid(boolean generateHoneyFluid) {
            this.generateHoneyFluid = generateHoneyFluid;
            return this;
        }

        public Builder addEffect(HoneyEffect effect) {
            this.effects.add(effect);
            return this;
        }

        public HoneyBottleData build() {
            return new HoneyBottleData(this.name, this.hunger, this.saturation, this.honeyColor, this.isRainbow, this.generateHoneyBlock, this.generateHoneyFluid, this.honeyBlockRecipe, this.effects);
        }
    }
}

