/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata.mutation;

import com.resourcefulbees.resourcefulbees.api.beedata.mutation.MutationOutput;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class Mutation {
    private final MutationTypes type;
    private final String inputID;
    private final double chance;
    private final List<MutationOutput> outputs;

    public Mutation(MutationTypes type, String inputID, double chance, MutationOutput ... outputs) {
        this.type = type;
        this.inputID = inputID;
        this.chance = chance;
        this.outputs = new ArrayList<MutationOutput>();
        this.outputs.addAll(Arrays.asList(outputs));
    }

    public MutationTypes getType() {
        return this.type;
    }

    public String getInputID() {
        return this.inputID.toLowerCase(Locale.ENGLISH);
    }

    public double getChance() {
        return this.chance == 0.0 ? 1.0 : Math.min(this.chance, 1.0);
    }

    public List<MutationOutput> getOutputs() {
        return this.outputs;
    }

    public boolean isTag() {
        return this.getInputID().startsWith("tag:");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append((Object)this.getType()).append(", ").append(this.getInputID()).append(", ").append(this.getChance()).append(", [");
        this.outputs.forEach(builder::append);
        builder.append("]]");
        return builder.toString();
    }
}

