/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.data.BeeTrait;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.potion.Effect;
import org.apache.commons.lang3.tuple.Pair;

public class TraitData
extends AbstractBeeData {
    private transient Set<Pair<Effect, Integer>> potionDamageEffects;
    private transient Set<String> damageImmunities;
    private transient Set<Effect> potionImmunities;
    private transient Set<Pair<String, Integer>> damageTypes;
    private transient Set<String> specialAbilities;
    private transient Set<BasicParticleType> particleEffects;
    private final boolean hasTraits;

    public TraitData(boolean hasTraits) {
        super("TraitData");
        this.hasTraits = hasTraits;
    }

    public void addTrait(BeeTrait trait) {
        if (trait != null) {
            if (trait.hasDamagePotionEffects()) {
                this.potionDamageEffects.addAll(trait.getPotionDamageEffects());
            }
            if (trait.hasDamageImmunities()) {
                this.damageImmunities.addAll(trait.getDamageImmunities());
            }
            if (trait.hasPotionImmunities()) {
                this.potionImmunities.addAll(trait.getPotionImmunities());
            }
            if (trait.hasDamageTypes()) {
                this.damageTypes.addAll(trait.getDamageTypes());
            }
            if (trait.hasSpecialAbilities()) {
                this.specialAbilities.addAll(trait.getSpecialAbilities());
            }
            if (trait.hasParticleEffect()) {
                this.particleEffects.add(trait.getParticleEffect());
            }
        }
    }

    public void initializeTraitSets() {
        this.potionDamageEffects = new HashSet<Pair<Effect, Integer>>();
        this.damageImmunities = new HashSet<String>();
        this.potionImmunities = new HashSet<Effect>();
        this.damageTypes = new HashSet<Pair<String, Integer>>();
        this.specialAbilities = new HashSet<String>();
        this.particleEffects = new HashSet<BasicParticleType>();
    }

    public boolean hasTraits() {
        return this.hasTraits;
    }

    public boolean hasDamagePotionEffects() {
        return this.hasTraits && !this.potionDamageEffects.isEmpty();
    }

    public boolean hasDamageImmunities() {
        return this.hasTraits && !this.damageImmunities.isEmpty();
    }

    public boolean hasPotionImmunities() {
        return this.hasTraits && !this.potionImmunities.isEmpty();
    }

    public boolean hasDamageTypes() {
        return this.hasTraits && !this.damageTypes.isEmpty();
    }

    public boolean hasSpecialAbilities() {
        return this.hasTraits && !this.specialAbilities.isEmpty();
    }

    public boolean hasParticleEffects() {
        return this.hasTraits && !this.particleEffects.isEmpty();
    }

    public Set<Pair<Effect, Integer>> getPotionDamageEffects() {
        return this.potionDamageEffects;
    }

    public Set<String> getDamageImmunities() {
        return this.damageImmunities;
    }

    public Set<Effect> getPotionImmunities() {
        return this.potionImmunities;
    }

    public Set<Pair<String, Integer>> getDamageTypes() {
        return this.damageTypes;
    }

    public Set<String> getSpecialAbilities() {
        return this.specialAbilities;
    }

    public Set<BasicParticleType> getParticleEffects() {
        return this.particleEffects;
    }

    public static TraitData createDefault() {
        return new TraitData(false);
    }
}

