/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.Mutation;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.BlockOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.EntityOutput;
import com.resourcefulbees.resourcefulbees.api.beedata.mutation.outputs.ItemOutput;
import com.resourcefulbees.resourcefulbees.lib.MutationTypes;
import com.resourcefulbees.resourcefulbees.utils.RandomCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MutationData
extends AbstractBeeData {
    public static final Logger LOGGER = LogManager.getLogger();
    @Deprecated
    private final String mutationInput;
    @Deprecated
    private final String mutationOutput;
    @Deprecated
    private final MutationTypes mutationType;
    private boolean hasMutation;
    private final int mutationCount;
    private final List<Mutation> mutations;
    private transient Map<Block, Pair<Double, RandomCollection<BlockOutput>>> blockMutations;
    private transient Map<ITag<?>, Pair<Double, RandomCollection<BlockOutput>>> jeiBlockTagMutations;
    private transient Map<Block, Pair<Double, RandomCollection<BlockOutput>>> jeiBlockMutations;
    private transient Map<EntityType<?>, Pair<Double, RandomCollection<EntityOutput>>> entityMutations;
    private transient Map<Block, Pair<Double, RandomCollection<ItemOutput>>> itemMutations;
    private transient Map<ITag<?>, Pair<Double, RandomCollection<ItemOutput>>> jeiBlockTagItemMutations;
    private transient Map<Block, Pair<Double, RandomCollection<ItemOutput>>> jeiItemMutations;

    private MutationData(String mutationInput, String mutationOutput, int mutationCount, boolean hasMutation, MutationTypes mutationType, List<Mutation> mutations) {
        super("MutationData");
        this.mutationInput = mutationInput;
        this.mutationOutput = mutationOutput;
        this.mutationCount = mutationCount;
        this.hasMutation = hasMutation;
        this.mutationType = mutationType;
        this.mutations = mutations;
    }

    public int getMutationCount() {
        return this.mutationCount <= 0 ? 10 : this.mutationCount;
    }

    public boolean hasMutation() {
        return this.hasMutation;
    }

    public boolean testMutations() {
        return this.hasMutation && (this.blockMutations != null && !this.blockMutations.isEmpty() || this.entityMutations != null && !this.entityMutations.isEmpty() || this.itemMutations != null && !this.itemMutations.isEmpty());
    }

    public void setHasMutation(boolean hasMutation) {
        this.hasMutation = hasMutation;
    }

    public String getMutationInput() {
        return this.mutationInput == null ? "" : this.mutationInput;
    }

    public String getMutationOutput() {
        return this.mutationOutput == null ? "" : this.mutationOutput;
    }

    public MutationTypes getMutationType() {
        return this.mutationType == null ? MutationTypes.NONE : this.mutationType;
    }

    public List<Mutation> getMutations() {
        return this.mutations == null ? new LinkedList() : this.mutations;
    }

    public void initializeMutations() {
        this.blockMutations = new HashMap<Block, Pair<Double, RandomCollection<BlockOutput>>>();
        this.jeiBlockMutations = new HashMap<Block, Pair<Double, RandomCollection<BlockOutput>>>();
        this.jeiBlockTagMutations = new HashMap();
        this.entityMutations = new HashMap();
        this.itemMutations = new HashMap<Block, Pair<Double, RandomCollection<ItemOutput>>>();
        this.jeiBlockTagItemMutations = new HashMap();
        this.jeiItemMutations = new HashMap<Block, Pair<Double, RandomCollection<ItemOutput>>>();
    }

    public void addBlockMutation(Block input, RandomCollection<BlockOutput> outputs, double chance) {
        this.blockMutations.put(input, (Pair<Double, RandomCollection<BlockOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addEntityMutation(EntityType<?> input, RandomCollection<EntityOutput> outputs, double chance) {
        this.entityMutations.put(input, (Pair<Double, RandomCollection<EntityOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addItemMutation(Block input, RandomCollection<ItemOutput> outputs, double chance) {
        this.itemMutations.put(input, (Pair<Double, RandomCollection<ItemOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addJeiBlockMutation(Block input, RandomCollection<BlockOutput> outputs, double chance) {
        this.jeiBlockMutations.put(input, (Pair<Double, RandomCollection<BlockOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addJeiBlockTagItemMutation(ITag<?> input, RandomCollection<ItemOutput> outputs, double chance) {
        this.jeiBlockTagItemMutations.put(input, (Pair<Double, RandomCollection<ItemOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addJeiItemMutation(Block input, RandomCollection<ItemOutput> outputs, double chance) {
        this.jeiItemMutations.put(input, (Pair<Double, RandomCollection<ItemOutput>>)Pair.of((Object)chance, outputs));
    }

    public void addJeiBlockTagMutation(ITag<?> input, RandomCollection<BlockOutput> outputs, double chance) {
        this.jeiBlockTagMutations.put(input, (Pair<Double, RandomCollection<BlockOutput>>)Pair.of((Object)chance, outputs));
    }

    public boolean hasBlockMutations() {
        return this.blockMutations != null && !this.blockMutations.isEmpty();
    }

    public boolean hasBlockTagMutations() {
        return this.jeiBlockTagMutations != null && !this.jeiBlockTagMutations.isEmpty();
    }

    public boolean hasEntityMutations() {
        return this.entityMutations != null && !this.entityMutations.isEmpty();
    }

    public boolean hasItemMutations() {
        return this.itemMutations != null && !this.itemMutations.isEmpty();
    }

    public boolean hasJeiBlockTagItemMutations() {
        return this.jeiBlockTagItemMutations != null && !this.jeiBlockTagItemMutations.isEmpty();
    }

    public boolean hasJeiItemMutations() {
        return this.jeiItemMutations != null && !this.jeiItemMutations.isEmpty();
    }

    public boolean hasJeiBlockMutations() {
        return this.jeiBlockMutations != null && !this.jeiBlockMutations.isEmpty();
    }

    public Map<ITag<?>, Pair<Double, RandomCollection<BlockOutput>>> getJeiBlockTagMutations() {
        return Collections.unmodifiableMap(this.jeiBlockTagMutations);
    }

    public Map<Block, Pair<Double, RandomCollection<BlockOutput>>> getBlockMutations() {
        return Collections.unmodifiableMap(this.blockMutations);
    }

    public Map<EntityType<?>, Pair<Double, RandomCollection<EntityOutput>>> getEntityMutations() {
        return Collections.unmodifiableMap(this.entityMutations);
    }

    public Map<Block, Pair<Double, RandomCollection<ItemOutput>>> getItemMutations() {
        return Collections.unmodifiableMap(this.itemMutations);
    }

    public Map<ITag<?>, Pair<Double, RandomCollection<ItemOutput>>> getJeiBlockTagItemMutations() {
        return Collections.unmodifiableMap(this.jeiBlockTagItemMutations);
    }

    public Map<Block, Pair<Double, RandomCollection<ItemOutput>>> getJeiItemMutations() {
        return Collections.unmodifiableMap(this.jeiItemMutations);
    }

    public Map<Block, Pair<Double, RandomCollection<BlockOutput>>> getJeiBlockMutations() {
        return Collections.unmodifiableMap(this.jeiBlockMutations);
    }

    public static MutationData createDefault() {
        MutationData data = new Builder(false, MutationTypes.NONE).createMutationData();
        data.initializeMutations();
        return data;
    }

    public static class Builder {
        private String mutationInput;
        private String mutationOutput;
        private int mutationCount;
        private final boolean hasMutation;
        private final MutationTypes mutationType;
        private final List<Mutation> mutations = new LinkedList<Mutation>();

        public Builder(boolean hasMutation, MutationTypes mutationType) {
            this.hasMutation = hasMutation;
            this.mutationType = mutationType;
        }

        public Builder setMutationInput(String mutationInput) {
            this.mutationInput = mutationInput;
            return this;
        }

        public Builder setMutationOutput(String mutationOutput) {
            this.mutationOutput = mutationOutput;
            return this;
        }

        public Builder setMutationCount(int mutationCount) {
            this.mutationCount = mutationCount;
            return this;
        }

        @Deprecated
        public MutationData createMutationData() {
            return new MutationData(this.mutationInput, this.mutationOutput, this.mutationCount, this.hasMutation, this.mutationType, this.mutations);
        }
    }
}

