/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class BreedData
extends AbstractBeeData {
    private boolean isBreedable;
    private final double breedWeight;
    private final float breedChance;
    private final String parent1;
    private final String parent2;
    private final String feedItem;
    private final String feedReturnItem;
    private final int feedAmount;
    private final int childGrowthDelay;
    private final int breedDelay;
    private transient HashSet<Item> feedingItems;

    private BreedData(boolean isBreedable, double breedWeight, float breedChance, String parent1, String parent2, String feedItem, String feedReturnItem, int feedAmount, int childGrowthDelay, int breedDelay) {
        super("BreedData");
        this.isBreedable = isBreedable;
        this.breedWeight = breedWeight;
        this.breedChance = breedChance;
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.feedItem = feedItem;
        this.feedReturnItem = feedReturnItem;
        this.feedAmount = feedAmount;
        this.childGrowthDelay = childGrowthDelay;
        this.breedDelay = breedDelay;
    }

    public boolean isBreedable() {
        return this.isBreedable;
    }

    public void setBreedable(boolean breedable) {
        this.isBreedable = breedable;
    }

    public double getBreedWeight() {
        return this.breedWeight <= 0.0 ? 10.0 : this.breedWeight;
    }

    public float getBreedChance() {
        return this.breedChance <= 0.0f ? 1.0f : this.breedChance;
    }

    public String getParent1() {
        return this.parent1 != null ? this.parent1.toLowerCase(Locale.ENGLISH) : "";
    }

    public String getParent2() {
        return this.parent2 != null ? this.parent2.toLowerCase(Locale.ENGLISH) : "";
    }

    public String getFeedItem() {
        return this.feedItem != null ? this.feedItem.toLowerCase(Locale.ENGLISH) : "all";
    }

    public void addFeedItem(Item item) {
        if (this.feedingItems == null) {
            this.feedingItems = new HashSet();
        }
        this.feedingItems.add(item);
    }

    public Set<Item> getFeedItems() {
        return this.feedingItems != null ? Collections.unmodifiableSet(this.feedingItems) : new HashSet();
    }

    public boolean hasFeedItems() {
        return this.feedingItems != null && !this.feedingItems.isEmpty();
    }

    public Item getFeedReturnItem() {
        if (this.feedReturnItem == null) {
            return Items.field_190931_a;
        }
        Item item = BeeInfoUtils.getItem(this.feedReturnItem.toLowerCase(Locale.ENGLISH));
        if (item == null) {
            return Items.field_190931_a;
        }
        return item;
    }

    public int getFeedAmount() {
        return Math.max(1, this.feedAmount);
    }

    public int getChildGrowthDelay() {
        return this.childGrowthDelay != 0 ? this.childGrowthDelay : -24000;
    }

    public int getBreedDelay() {
        return this.breedDelay != 0 ? this.breedDelay : 6000;
    }

    public boolean hasParents() {
        return !this.getParent1().isEmpty() && !this.getParent2().isEmpty();
    }

    public static BreedData createDefault() {
        return new Builder(false).createBreedData();
    }

    public static class Builder {
        private final boolean isBreedable;
        private double breedWeight;
        private float breedChance;
        private String parent1;
        private String parent2;
        private String feedItem;
        private String feedReturnItem;
        private int feedAmount;
        private int childGrowthDelay;
        private int breedDelay;

        public Builder(boolean isBreedable) {
            this.isBreedable = isBreedable;
        }

        public Builder setBreedWeight(double breedWeight) {
            this.breedWeight = breedWeight;
            return this;
        }

        public Builder setBreedChance(float breedChance) {
            this.breedChance = breedChance;
            return this;
        }

        public Builder setParent1(String parent1) {
            this.parent1 = parent1;
            return this;
        }

        public Builder setParent2(String parent2) {
            this.parent2 = parent2;
            return this;
        }

        public Builder setFeedItem(String feedItem) {
            this.feedItem = feedItem;
            return this;
        }

        public Builder setFeedReturnItem(String feedReturnItem) {
            this.feedReturnItem = feedReturnItem;
            return this;
        }

        public Builder setFeedAmount(int feedAmount) {
            this.feedAmount = feedAmount;
            return this;
        }

        public Builder setChildGrowthDelay(int childGrowthDelay) {
            this.childGrowthDelay = childGrowthDelay;
            return this;
        }

        public Builder setBreedDelay(int breedDelay) {
            this.breedDelay = breedDelay;
            return this;
        }

        public BreedData createBreedData() {
            return new BreedData(this.isBreedable, this.breedWeight, this.breedChance, this.parent1, this.parent2, this.feedItem, this.feedReturnItem, this.feedAmount, this.childGrowthDelay, this.breedDelay);
        }
    }
}

