/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.io.ConfigLoader;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.bedrock.BedrockFlattener;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CaveCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CavernCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.LiquidRegionController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.RavineCarverController;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class MasterController {
    private ISeedReader world;
    public long seed = 0L;
    public ConfigHolder configHolder;
    private CaveCarverController caveCarverController;
    private CavernCarverController cavernCarverController;
    private LiquidRegionController liquidRegionController;
    private RavineCarverController ravineCarverController;

    public boolean carveRegion(IChunk chunkIn, Function<BlockPos, Biome> biomePos, int chunkX, int chunkZ, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.configHolder.flattenBedrock.get().booleanValue()) {
            BedrockFlattener.flattenBedrock(chunkIn, biomePos, this.configHolder.bedrockWidth.get());
        }
        int[][] surfaceAltitudes = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                surfaceAltitudes[x][z] = this.configHolder.overrideSurfaceDetection.get() != false ? 1 : Math.min(chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z), chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z));
            }
        }
        BlockState[][] liquidBlocks = this.liquidRegionController.getLiquidBlocksForChunk(chunkX, chunkZ);
        this.ravineCarverController.carveChunk(chunkIn, chunkX, chunkZ, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        this.caveCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        this.cavernCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        return true;
    }

    public void initialize(ISeedReader worldIn) {
        this.world = worldIn;
        this.seed = worldIn.func_72905_C();
        String dimensionName = "";
        try {
            dimensionName = Objects.requireNonNull(this.world.func_201672_e().func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! This could be a problem...");
        }
        this.configHolder = dimensionName.equals("") ? new ConfigHolder() : ConfigLoader.loadConfigFromFileForDimension(dimensionName);
        this.caveCarverController = new CaveCarverController(worldIn, this.configHolder);
        this.cavernCarverController = new CavernCarverController(worldIn, this.configHolder);
        this.liquidRegionController = new LiquidRegionController(worldIn, this.configHolder);
        this.ravineCarverController = new RavineCarverController(worldIn, this.configHolder);
        BetterCaves.LOGGER.debug(String.format("BETTER CAVES WORLD CARVER INITIALIZED WITH SEED %d IN %s", this.seed, dimensionName));
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
        this.caveCarverController.setWorld(worldIn);
        this.cavernCarverController.setWorld(worldIn);
        this.liquidRegionController.setWorld(worldIn);
        this.ravineCarverController.setWorld(worldIn);
    }

    public long getSeed() {
        return this.seed;
    }
}

