/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationInventory;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;
import slimeknights.tconstruct.tools.modifiers.slotless.CreativeSlotModifier;

public class CreativeSlotRecipe
implements ITinkerStationRecipe {
    private final ResourceLocation id;

    @Nullable
    private SlotType findSlotType(ITinkerStationInventory inv, boolean stopAfterFirst) {
        SlotType type = null;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.func_190926_b()) continue;
            if (type != null || stack.func_77973_b() != TinkerModifiers.creativeSlotItem.get()) {
                return null;
            }
            type = CreativeSlotItem.getSlot(stack);
            if (type == null) {
                return null;
            }
            if (!stopAfterFirst) continue;
            return type;
        }
        return type;
    }

    @Override
    public boolean matches(ITinkerStationInventory inv, World world) {
        if (!TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)inv.getTinkerableStack().func_77973_b())) {
            return false;
        }
        return this.findSlotType(inv, false) != null;
    }

    @Override
    public ItemStack getCraftingResult(ITinkerStationInventory inv) {
        CompoundNBT slots;
        ToolStack toolStack = ToolStack.copyFrom(inv.getTinkerableStack());
        ModDataNBT persistentData = toolStack.getPersistentData();
        if (persistentData.contains(CreativeSlotModifier.KEY_SLOTS, 10)) {
            slots = persistentData.getCompound(CreativeSlotModifier.KEY_SLOTS);
        } else {
            slots = new CompoundNBT();
            persistentData.put(CreativeSlotModifier.KEY_SLOTS, (INBT)slots);
        }
        SlotType slotType = this.findSlotType(inv, true);
        if (slotType != null) {
            String name = slotType.getName();
            slots.func_74768_a(name, slots.func_74762_e(name) + 1);
        }
        if (toolStack.getModifierLevel((Modifier)TinkerModifiers.creativeSlot.get()) == 0) {
            toolStack.addModifier((Modifier)TinkerModifiers.creativeSlot.get(), 1);
        } else {
            toolStack.rebuildStats();
        }
        return toolStack.createStack();
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.creativeSlotSerializer.get();
    }

    public CreativeSlotRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }
}

