/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class CreativeSlotModifier
extends SingleUseModifier {
    private static final String SLOT_PREFIX = TConstruct.makeTranslationKey("modifier", "creative_slot.prefix");
    public static final ResourceLocation KEY_SLOTS = TConstruct.getResource("creative");

    public CreativeSlotModifier() {
        super(13417031);
    }

    @Override
    public void addVolatileData(Item item, ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT volatileData) {
        if (persistentData.contains(KEY_SLOTS, 10)) {
            CompoundNBT slots = persistentData.getCompound(KEY_SLOTS);
            for (String key : slots.func_150296_c()) {
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                volatileData.addSlots(slotType, slots.func_74762_e(key));
            }
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        ModDataNBT persistentData;
        if (detailed && (persistentData = tool.getPersistentData()).contains(KEY_SLOTS, 10)) {
            CompoundNBT slots = persistentData.getCompound(KEY_SLOTS);
            Iterator keys = slots.func_150296_c().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                SlotType slotType = SlotType.getIfPresent(key);
                if (slotType == null) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent(SLOT_PREFIX));
                tooltip.add((ITextComponent)new StringTextComponent("* +" + slots.func_74762_e(key) + " ").func_230529_a_(slotType.getDisplayName()).func_240700_a_(style -> style.func_240718_a_(slotType.getColor())));
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    SlotType slotType2 = SlotType.getIfPresent(key);
                    if (slotType2 == null) continue;
                    tooltip.add((ITextComponent)new StringTextComponent("* +" + slots.func_74762_e(key) + " ").func_230529_a_(slotType2.getDisplayName()).func_240700_a_(style -> style.func_240718_a_(slotType2.getColor())));
                }
                break block0;
            }
        }
    }
}

