/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.modifiers.hooks.IHarvestModifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.item.IModifiableHarvest;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class HarvestAbilityModifier
extends SingleUseModifier {
    private final int priority;

    public HarvestAbilityModifier(int color, int priority) {
        super(color);
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    private static boolean harvestInteract(ItemUseContext context, ServerWorld world, BlockState state, BlockPos pos, @Nullable PlayerEntity player) {
        if (player == null) {
            return false;
        }
        BlockRayTraceResult trace = new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), pos, false);
        ActionResultType result = state.func_227031_a_((World)world, player, context.func_221531_n(), trace);
        return result.func_226246_a_();
    }

    private static boolean harvestStackable(ServerWorld world, BlockState state, BlockPos pos, @Nullable PlayerEntity player) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == state.func_177230_c()) {
            world.func_225521_a_(pos, true, (Entity)player);
            return true;
        }
        BlockPos up = pos.func_177984_a();
        if (world.func_180495_p(up).func_177230_c() == state.func_177230_c()) {
            world.func_225521_a_(up, true, (Entity)player);
            return true;
        }
        return false;
    }

    private static boolean harvestCrop(ItemStack stack, ServerWorld world, BlockState state, BlockPos pos, @Nullable PlayerEntity player) {
        BlockState replant;
        Block block = state.func_177230_c();
        if (block instanceof CropsBlock) {
            CropsBlock crops = (CropsBlock)block;
            if (!crops.func_185525_y(state)) {
                return false;
            }
            replant = crops.func_185528_e(0);
        } else {
            IntegerProperty age = null;
            for (Property prop : state.func_235904_r_()) {
                if (!prop.func_177701_a().equals("age") || !(prop instanceof IntegerProperty)) continue;
                age = (IntegerProperty)prop;
                break;
            }
            if (age == null) {
                return false;
            }
            Collection allowedValues = age.func_177700_c();
            if (!allowedValues.contains(0)) {
                return false;
            }
            int maxAge = age.func_177700_c().stream().max(Integer::compareTo).orElse(Integer.MAX_VALUE);
            if ((Integer)state.func_177229_b((Property)age) < maxAge) {
                return false;
            }
            replant = (BlockState)state.func_206870_a((Property)age, (Comparable)Integer.valueOf(0));
        }
        LootContext.Builder lootContext = new LootContext.Builder(world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(pos));
        List drops = state.func_215693_a(lootContext);
        Iterator iterator = drops.iterator();
        boolean hasSeed = false;
        while (iterator.hasNext()) {
            ItemStack drop = (ItemStack)iterator.next();
            if (!TinkerTags.Items.SEEDS.func_230235_a_((Object)drop.func_77973_b())) continue;
            hasSeed = true;
            drop.func_190918_g(1);
            if (!drop.func_190926_b()) break;
            iterator.remove();
            break;
        }
        if (hasSeed) {
            world.func_175656_a(pos, replant);
            state.func_215706_a(world, pos, stack);
            world.func_184133_a(null, pos, state.getSoundType((IWorldReader)world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else {
            world.func_175655_b(pos, false);
        }
        for (ItemStack drop : drops) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
        }
        return true;
    }

    private static boolean harvest(ItemUseContext context, ItemStack stack, IModifierToolStack tool, ServerWorld world, BlockState state, BlockPos pos, @Nullable PlayerEntity player) {
        Block block = state.func_177230_c();
        if (!TinkerTags.Blocks.HARVESTABLE.func_230235_a_((Object)block)) {
            return false;
        }
        boolean didHarvest = false;
        Event.Result result = new TinkerToolEvent.ToolHarvestEvent(stack, tool, context, world, state, pos, player).fire();
        if (result != Event.Result.DEFAULT) {
            didHarvest = result == Event.Result.ALLOW;
        } else if (TinkerTags.Blocks.HARVESTABLE_INTERACT.func_230235_a_((Object)block)) {
            didHarvest = HarvestAbilityModifier.harvestInteract(context, world, state, pos, player);
        } else if (TinkerTags.Blocks.HARVESTABLE_STACKABLE.func_230235_a_((Object)block)) {
            didHarvest = HarvestAbilityModifier.harvestStackable(world, state, pos, player);
        } else if (TinkerTags.Blocks.HARVESTABLE_CROPS.func_230235_a_((Object)block)) {
            didHarvest = HarvestAbilityModifier.harvestCrop(stack, world, state, pos, player);
        }
        if (didHarvest) {
            for (ModifierEntry entry : tool.getModifierList()) {
                IHarvestModifier harvest = entry.getModifier().getModule(IHarvestModifier.class);
                if (harvest == null) continue;
                harvest.afterHarvest(tool, entry.getLevel(), context, world, state, pos);
            }
        }
        return didHarvest;
    }

    @Override
    public ActionResultType beforeBlockUse(IModifierToolStack tool, int level, ItemUseContext context) {
        BlockPos pos;
        if (tool.isBroken()) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        if (TinkerTags.Blocks.HARVESTABLE.func_230235_a_((Object)state.func_177230_c())) {
            if (world instanceof ServerWorld) {
                boolean survival = player == null || !player.func_184812_l_();
                ServerWorld server = (ServerWorld)world;
                boolean didHarvest = false;
                boolean broken = false;
                ItemStack stack = context.func_195996_i();
                if (HarvestAbilityModifier.harvest(context, stack, tool, server, state, pos, player)) {
                    didHarvest = true;
                    broken = survival && ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack);
                }
                Item item = stack.func_77973_b();
                if (!broken && player != null && item instanceof IModifiableHarvest) {
                    for (BlockPos newPos : ((IModifiableHarvest)item).getToolHarvestLogic().getAOEBlocks(tool, stack, player, state, world, pos, context.func_196000_l(), ToolHarvestLogic.AOEMatchType.TRANSFORM)) {
                        if (!HarvestAbilityModifier.harvest(context, stack, tool, server, world.func_180495_p(newPos), newPos, player)) continue;
                        didHarvest = true;
                        if (!survival || !ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) continue;
                        broken = true;
                        break;
                    }
                }
                if (player != null) {
                    if (didHarvest) {
                        player.func_184810_cG();
                    }
                    if (broken) {
                        player.func_213334_d(context.func_221531_n());
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

