/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.List;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.tools.stat.ToolStatsBuilder;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public final class MeleeHarvestToolStatsBuilder
extends ToolStatsBuilder {
    private final List<HeadMaterialStats> heads;
    private final List<HandleMaterialStats> handles;
    private final List<ExtraMaterialStats> extras;

    public MeleeHarvestToolStatsBuilder(ToolBaseStatDefinition baseStats, List<HeadMaterialStats> heads, List<HandleMaterialStats> handles, List<ExtraMaterialStats> extras) {
        super(baseStats);
        this.heads = heads;
        this.handles = handles;
        this.extras = extras;
    }

    public static ToolStatsBuilder from(ToolDefinition toolDefinition, List<IMaterial> materials) {
        List<IToolPart> requiredComponents = toolDefinition.getRequiredComponents();
        if (materials.size() != requiredComponents.size()) {
            return ToolStatsBuilder.noParts(toolDefinition);
        }
        ToolBaseStatDefinition baseStats = toolDefinition.getBaseStatDefinition();
        List<HeadMaterialStats> headStats = MeleeHarvestToolStatsBuilder.listOfCompatibleWith(HeadMaterialStats.ID, materials, requiredComponents);
        int primaryWeight = baseStats.getPrimaryHeadWeight();
        if (primaryWeight > 1 && headStats.size() > 1) {
            for (int i = 1; i < primaryWeight; ++i) {
                headStats.add((HeadMaterialStats)headStats.get(0));
            }
        }
        return new MeleeHarvestToolStatsBuilder(baseStats, headStats, MeleeHarvestToolStatsBuilder.listOfCompatibleWith(HandleMaterialStats.ID, materials, requiredComponents), MeleeHarvestToolStatsBuilder.listOfCompatibleWith(ExtraMaterialStats.ID, materials, requiredComponents));
    }

    @Override
    protected void setStats(StatsNBT.Builder builder) {
        builder.set(ToolStats.DURABILITY, this.buildDurability());
        builder.set(ToolStats.HARVEST_LEVEL, this.buildHarvestLevel());
        builder.set(ToolStats.ATTACK_DAMAGE, this.buildAttackDamage());
        builder.set(ToolStats.ATTACK_SPEED, this.buildAttackSpeed());
        builder.set(ToolStats.MINING_SPEED, this.buildMiningSpeed());
    }

    @Override
    protected boolean handles(IToolStat<?> stat) {
        return stat == ToolStats.DURABILITY || stat == ToolStats.HARVEST_LEVEL || stat == ToolStats.ATTACK_DAMAGE || stat == ToolStats.ATTACK_SPEED || stat == ToolStats.MINING_SPEED;
    }

    public float buildDurability() {
        double averageHeadDurability = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getDurability) + (double)this.baseStats.getBonus(ToolStats.DURABILITY);
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getDurability, 1.0);
        return Math.max(1, (int)(averageHeadDurability * averageHandleModifier));
    }

    public float buildMiningSpeed() {
        double averageHeadSpeed = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getMiningSpeed) + (double)this.baseStats.getBonus(ToolStats.MINING_SPEED);
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getMiningSpeed, 1.0);
        return (float)Math.max(0.1, averageHeadSpeed * averageHandleModifier);
    }

    public float buildAttackSpeed() {
        float baseSpeed = ToolStats.ATTACK_SPEED.getDefaultValue() + this.baseStats.getBonus(ToolStats.ATTACK_SPEED);
        double averageHandleModifier = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getAttackSpeed, 1.0);
        return (float)Math.max(0.0, (double)baseSpeed * averageHandleModifier);
    }

    public int buildHarvestLevel() {
        return this.heads.stream().mapToInt(HeadMaterialStats::getHarvestLevel).max().orElse(0);
    }

    public float buildAttackDamage() {
        double averageHeadAttack = MeleeHarvestToolStatsBuilder.getAverageValue(this.heads, HeadMaterialStats::getAttack) + (double)this.baseStats.getBonus(ToolStats.ATTACK_DAMAGE);
        double averageHandle = MeleeHarvestToolStatsBuilder.getAverageValue(this.handles, HandleMaterialStats::getAttackDamage, 1.0);
        return (float)Math.max(0.0, averageHeadAttack * averageHandle);
    }

    protected List<HeadMaterialStats> getHeads() {
        return this.heads;
    }

    protected List<HandleMaterialStats> getHandles() {
        return this.handles;
    }

    protected List<ExtraMaterialStats> getExtras() {
        return this.extras;
    }
}

