/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.network;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.tables.inventory.table.tinkerstation.TinkerStationContainer;

public class TinkerStationSelectionPacket
implements IThreadsafePacket {
    private final int activeSlots;
    private final boolean tinkerSlotHidden;
    private final Item toolFilter;

    public TinkerStationSelectionPacket(PacketBuffer buffer) {
        this.activeSlots = buffer.readInt();
        this.tinkerSlotHidden = buffer.readBoolean();
        this.toolFilter = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.activeSlots);
        buffer.writeBoolean(this.tinkerSlotHidden);
        buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)this.toolFilter);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        Container container;
        ServerPlayerEntity sender = context.getSender();
        if (sender != null && (container = sender.field_71070_bA) instanceof TinkerStationContainer) {
            ToolDefinition filter = null;
            if (this.toolFilter instanceof IModifiable) {
                filter = ((IModifiable)this.toolFilter).getToolDefinition();
            }
            ((TinkerStationContainer)container).setToolSelection(this.activeSlots, this.tinkerSlotHidden, filter);
        }
    }

    public TinkerStationSelectionPacket(int activeSlots, boolean tinkerSlotHidden, Item toolFilter) {
        this.activeSlots = activeSlots;
        this.tinkerSlotHidden = tinkerSlotHidden;
        this.toolFilter = toolFilter;
    }
}

