/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.controller;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.tileentity.controller.HeatingStructureTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.ByproductMeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.FoundryMultiblock;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.HeatingStructureMultiblock;

public class FoundryTileEntity
extends HeatingStructureTileEntity {
    private static final int CAPACITY_PER_BLOCK = 1152;
    private static final int BLOCKS_PER_FUEL = 18;

    public FoundryTileEntity() {
        super((TileEntityType<? extends HeatingStructureTileEntity>)((TileEntityType)TinkerSmeltery.foundry.get()), (ITextComponent)TConstruct.makeTranslation("gui", "foundry"));
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new FoundryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new ByproductMeltingModuleInventory((MantleTileEntity)this, this.tank, () -> Config.COMMON.foundryNuggetsPerOre.get());
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.field_145850_b == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    if (!this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    BlockState state = this.func_195044_w();
                    if ((Boolean)state.func_177229_b((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            this.tank.setCapacity(1152 * (dx + 2) * (dy + 1) * (dz + 2));
            this.meltingInventory.resize(dx * dy * dz, this.dropItem);
            this.fuelRate = 1 + (2 * ((dx + 2) * dy) + 2 * (dy * dz) + (dx + 2) * (dz + 2)) / 18;
        }
    }
}

