/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.events.MaterialsLoadedEvent;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.CraftingStationTransferInfo;
import slimeknights.tconstruct.plugin.jei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.jei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientHelper;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.jei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientHelper;
import slimeknights.tconstruct.plugin.jei.partbuilder.PatternIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.transfer.TinkerStationTransferInfo;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.client.inventory.HeatingStructureScreen;
import slimeknights.tconstruct.smeltery.client.inventory.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.inventory.MelterScreen;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final IIngredientType<EntityType> ENTITY_TYPE = () -> EntityType.class;
    public static final IIngredientType<ModifierEntry> MODIFIER_TYPE = () -> ModifierEntry.class;
    public static final IIngredientType<Pattern> PATTERN_TYPE = () -> Pattern.class;
    private final MaterialReloadListener materialReloader = new MaterialReloadListener();

    public JEIPlugin() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, MaterialsLoadedEvent.class, (Consumer)this.materialReloader);
    }

    public ResourceLocation getPluginUid() {
        return TConstructRecipeCategoryUid.pluginUid;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingBasinCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CastingTableCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MoldingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MeltingCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EntityMeltingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new FoundryCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ModifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SeveringCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PartBuilderCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(ENTITY_TYPE, Collections.emptyList(), (IIngredientHelper)new EntityIngredientHelper(), (IIngredientRenderer)new EntityIngredientRenderer(16));
        registration.register(MODIFIER_TYPE, Collections.emptyList(), (IIngredientHelper)new ModifierIngredientHelper(), (IIngredientRenderer)new ModifierIngredientRenderer(16));
        registration.register(PATTERN_TYPE, Collections.emptyList(), (IIngredientHelper)new PatternIngredientHelper(), (IIngredientRenderer)PatternIngredientRenderer.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration register) {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        RecipeManager manager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.CASTING_BASIN, IDisplayableCastingRecipe.class);
        register.addRecipes((Collection)castingBasinRecipes, TConstructRecipeCategoryUid.castingBasin);
        List castingTableRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.CASTING_TABLE, IDisplayableCastingRecipe.class);
        register.addRecipes((Collection)castingTableRecipes, TConstructRecipeCategoryUid.castingTable);
        List meltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MELTING, MeltingRecipe.class);
        register.addRecipes((Collection)meltingRecipes, TConstructRecipeCategoryUid.melting);
        register.addRecipes((Collection)meltingRecipes, TConstructRecipeCategoryUid.foundry);
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.FUEL, MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.ENTITY_MELTING, EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        register.addRecipes((Collection)entityMeltingRecipes, TConstructRecipeCategoryUid.entityMelting);
        List alloyRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.ALLOYING, AlloyRecipe.class);
        register.addRecipes((Collection)alloyRecipes, TConstructRecipeCategoryUid.alloy);
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MOLDING_TABLE, MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.MOLDING_BASIN, MoldingRecipe.class)).build();
        register.addRecipes((Collection)moldingRecipes, TConstructRecipeCategoryUid.molding);
        List modifierRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.TINKER_STATION, IDisplayModifierRecipe.class);
        register.addRecipes((Collection)modifierRecipes, TConstructRecipeCategoryUid.modifiers);
        List severingRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.SEVERING, SeveringRecipe.class);
        register.addRecipes((Collection)severingRecipes, TConstructRecipeCategoryUid.severing);
        List materialRecipes = RecipeHelper.getRecipes((RecipeManager)manager, RecipeTypes.MATERIAL, MaterialRecipe.class);
        MaterialItemList.setRecipes(materialRecipes);
        List partRecipes = RecipeHelper.getJEIRecipes((RecipeManager)manager, RecipeTypes.PART_BUILDER, IDisplayPartBuilderRecipe.class);
        register.addRecipes((Collection)partRecipes, TConstructRecipeCategoryUid.partBuilder);
    }

    private static <T extends IRecipe<C>, C extends IInventory> void addCastingCatalyst(IRecipeCatalystRegistration registry, IItemProvider item, ResourceLocation ownCategory, IRecipeType<T> type) {
        ItemStack stack = new ItemStack(item);
        registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{ownCategory});
        assert (Minecraft.func_71410_x().field_71441_e != null);
        if (!Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215366_a(type).isEmpty()) {
            registry.addRecipeCatalyst((Object)stack, new ResourceLocation[]{TConstructRecipeCategoryUid.molding});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerTables.partBuilder), new ResourceLocation[]{TConstructRecipeCategoryUid.partBuilder});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerTables.tinkerStation), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerTables.tinkersAnvil), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerTables.scorchedAnvil), new ResourceLocation[]{TConstructRecipeCategoryUid.modifiers});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.searedMelter), new ResourceLocation[]{TConstructRecipeCategoryUid.melting});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.searedHeater), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructRecipeCategoryUid.castingTable, RecipeTypes.MOLDING_TABLE);
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructRecipeCategoryUid.castingBasin, RecipeTypes.MOLDING_BASIN);
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.smelteryController), new ResourceLocation[]{TConstructRecipeCategoryUid.melting, TConstructRecipeCategoryUid.alloy, TConstructRecipeCategoryUid.entityMelting});
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.scorchedAlloyer), new ResourceLocation[]{TConstructRecipeCategoryUid.alloy});
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructRecipeCategoryUid.castingTable, RecipeTypes.MOLDING_TABLE);
        JEIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructRecipeCategoryUid.castingBasin, RecipeTypes.MOLDING_BASIN);
        registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.foundryController), new ResourceLocation[]{TConstructRecipeCategoryUid.foundry});
        for (Item item : TinkerTags.Items.MELEE.func_230236_b_()) {
            registry.addRecipeCatalyst((Object)IModifiableDisplay.getDisplayStack(item), new ResourceLocation[]{TConstructRecipeCategoryUid.severing});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        RetexturedSubtypeInterpreter tables = new RetexturedSubtypeInterpreter();
        registry.registerSubtypeInterpreter(TinkerTables.craftingStation.func_199767_j(), (ISubtypeInterpreter)tables);
        registry.registerSubtypeInterpreter(TinkerTables.partBuilder.func_199767_j(), (ISubtypeInterpreter)tables);
        registry.registerSubtypeInterpreter(TinkerTables.tinkerStation.func_199767_j(), (ISubtypeInterpreter)tables);
        registry.registerSubtypeInterpreter(TinkerTables.tinkersAnvil.func_199767_j(), (ISubtypeInterpreter)tables);
        registry.registerSubtypeInterpreter(TinkerTables.scorchedAnvil.func_199767_j(), (ISubtypeInterpreter)tables);
        ISubtypeInterpreter toolPartInterpreter = itemStack -> {
            MaterialId materialId = IMaterialItem.getMaterialIdFromStack(itemStack);
            if (materialId.equals((Object)IMaterial.UNKNOWN_ID)) {
                return "";
            }
            return materialId.toString();
        };
        for (Item item : TinkerTags.Items.TOOL_PARTS.func_230236_b_()) {
            registry.registerSubtypeInterpreter(item, toolPartInterpreter);
        }
        ToolSubtypeInterpreter toolInterpreter = new ToolSubtypeInterpreter();
        for (Item item : TinkerTags.Items.MULTIPART_TOOL.func_230236_b_()) {
            registry.registerSubtypeInterpreter(item, (ISubtypeInterpreter)toolInterpreter);
        }
        registry.registerSubtypeInterpreter((Item)TinkerSmeltery.copperCan.get(), CopperCanItem::getSubtype);
        registry.registerSubtypeInterpreter((Item)TinkerModifiers.creativeSlotItem.get(), stack -> {
            SlotType slotType = CreativeSlotItem.getSlot(stack);
            return slotType != null ? slotType.getName() : "";
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(MelterScreen.class, new GuiContainerTankHandler());
        registration.addGenericGuiContainerHandler(HeatingStructureScreen.class, new GuiContainerTankHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new TinkerStationTransferInfo());
    }

    private static void removeFluid(IIngredientManager manager, Fluid fluid, Item bucket) {
        manager.removeIngredientsAtRuntime(VanillaTypes.FLUID, Collections.singleton(new FluidStack(fluid, 1000)));
        manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singleton(new ItemStack((IItemProvider)bucket)));
    }

    private static void optionalCast(IIngredientManager manager, CastItemObject cast) {
        ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation("forge", cast.getName().func_110623_a() + "s"));
        if (tag == null || tag.func_230236_b_().isEmpty()) {
            manager.removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)cast.values().stream().map(ItemStack::new).collect(Collectors.toList()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IIngredientManager manager = jeiRuntime.getIngredientManager();
        this.materialReloader.manager = manager;
        if (MaterialRegistry.isFullyLoaded()) {
            this.materialReloader.run();
        }
        JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenSoulsteel.get(), TinkerFluids.moltenSoulsteel.func_199767_j());
        JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenKnightslime.get(), TinkerFluids.moltenKnightslime.func_199767_j());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            ITag ingot = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(new ResourceLocation("forge", "ingots/" + compat.getName()));
            if (ingot != null && !ingot.func_230236_b_().isEmpty()) continue;
            JEIPlugin.removeFluid(manager, (Fluid)compat.getFluid().get(), compat.getBucket());
        }
        if (!ModList.get().isLoaded("ceramics")) {
            JEIPlugin.removeFluid(manager, (Fluid)TinkerFluids.moltenPorcelain.get(), TinkerFluids.moltenPorcelain.func_199767_j());
        }
        JEIPlugin.optionalCast(manager, TinkerSmeltery.plateCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.gearCast);
        JEIPlugin.optionalCast(manager, TinkerSmeltery.coinCast);
    }

    private static class MaterialReloadListener
    implements Consumer<MaterialsLoadedEvent> {
        private IIngredientManager manager;

        private MaterialReloadListener() {
        }

        private void deferredRun() {
            NonNullList newStacks = NonNullList.func_191196_a();
            for (Item item : TinkerTags.Items.TOOL_PARTS.func_230236_b_()) {
                item.func_150895_a(ItemGroup.field_78027_g, newStacks);
            }
            for (Item item : TinkerTags.Items.MULTIPART_TOOL.func_230236_b_()) {
                item.func_150895_a(ItemGroup.field_78027_g, newStacks);
            }
            if (!newStacks.isEmpty()) {
                this.manager.addIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)newStacks);
            }
        }

        public void run() {
            if (this.manager != null && !MaterialRegistry.getMaterials().isEmpty()) {
                Minecraft.func_71410_x().execute(this::deferredRun);
            }
        }

        @Override
        public void accept(MaterialsLoadedEvent event) {
            this.run();
        }
    }

    public static class RetexturedSubtypeInterpreter
    implements ISubtypeInterpreter {
        public String apply(ItemStack itemStack) {
            return "";
        }

        public String apply(ItemStack itemStack, UidContext context) {
            if (context == UidContext.Ingredient) {
                return RetexturedBlockItem.getTextureName((ItemStack)itemStack);
            }
            return "";
        }
    }

    public static class ToolSubtypeInterpreter
    implements ISubtypeInterpreter {
        public String apply(ItemStack itemStack) {
            return "";
        }

        public String apply(ItemStack itemStack, UidContext context) {
            if (context == UidContext.Ingredient) {
                StringBuilder builder = new StringBuilder();
                List<MaterialId> materialList = MaterialIdNBT.from(itemStack).getMaterials();
                if (!materialList.isEmpty()) {
                    builder.append((Object)materialList.get(0));
                    for (int i = 1; i < materialList.size(); ++i) {
                        builder.append(',');
                        builder.append((Object)materialList.get(i));
                    }
                }
                return builder.toString();
            }
            return "";
        }
    }

    public static class GuiContainerTankHandler<C extends Container, T extends ContainerScreen<C>>
    implements IGuiContainerHandler<T> {
        @Nullable
        public Object getIngredientUnderMouse(T containerScreen, double mouseX, double mouseY) {
            return ((IScreenWithFluidTank)containerScreen).getIngredientUnderMouse(mouseX, mouseY);
        }
    }
}

