/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.library.utils.Util;

public class HarvestLevels
implements ISafeManagerReloadListener {
    public static final HarvestLevels INSTANCE = new HarvestLevels();
    public static final int WOOD = 0;
    public static final int STONE = 1;
    public static final int IRON = 2;
    public static final int DIAMOND = 3;
    public static final int NETHERITE = 4;
    private static boolean namesLoaded = false;
    private static final Map<Integer, ITextComponent> harvestLevelNames = Maps.newHashMap();

    private static IFormattableTextComponent makeLevelKey(String levelName) {
        return new TranslationTextComponent(TConstruct.makeTranslationKey("stat", "mining_level." + levelName));
    }

    private static void loadNames() {
        if (namesLoaded) {
            return;
        }
        namesLoaded = true;
        harvestLevelNames.put(0, (ITextComponent)HarvestLevels.makeLevelKey("wood").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)9332251))));
        harvestLevelNames.put(1, (ITextComponent)HarvestLevels.makeLevelKey("stone").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)0x999999))));
        harvestLevelNames.put(2, (ITextComponent)HarvestLevels.makeLevelKey("iron").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)0xCACACA))));
        harvestLevelNames.put(3, (ITextComponent)HarvestLevels.makeLevelKey("diamond").func_240699_a_(TextFormatting.AQUA));
        harvestLevelNames.put(4, (ITextComponent)HarvestLevels.makeLevelKey("netherite").func_240699_a_(TextFormatting.DARK_GRAY));
        String base = TConstruct.makeTranslationKey("stat", "mining_level.");
        int i = 0;
        while (Util.canTranslate(base + i)) {
            harvestLevelNames.put(i, (ITextComponent)new TranslationTextComponent(base + i));
            ++i;
        }
    }

    public static ITextComponent getHarvestLevelName(int num) {
        HarvestLevels.loadNames();
        return harvestLevelNames.computeIfAbsent(num, n -> new StringTextComponent(Integer.toString(num)));
    }

    @Override
    public void onReloadSafe(IResourceManager resourceManager) {
        harvestLevelNames.clear();
        namesLoaded = false;
    }

    private HarvestLevels() {
    }
}

