/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.Util;

public interface IToolStat<B> {
    public ToolStatId getName();

    public float getDefaultValue();

    public float clamp(float var1);

    public B makeBuilder();

    public float build(B var1, float var2);

    default public IFormattableTextComponent getPrefix() {
        return new TranslationTextComponent(Util.makeTranslationKey("tool_stat", this.getName()));
    }

    default public IFormattableTextComponent getDescription() {
        return new TranslationTextComponent(Util.makeTranslationKey("tool_stat", this.getName()) + ".description");
    }

    public ITextComponent formatValue(float var1);

    public static ITextComponent formatNumber(String loc, Color color, int number) {
        return IToolStat.formatNumber(loc, color, (float)number);
    }

    public static ITextComponent formatNumber(String loc, Color color, float number) {
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.COMMA_FORMAT.format(number)).func_240700_a_(style -> style.func_240718_a_(color)));
    }

    public static ITextComponent formatNumberPercent(String loc, Color color, float number) {
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.PERCENT_FORMAT.format(number)).func_240700_a_(style -> style.func_240718_a_(color)));
    }

    public static ITextComponent formatColoredMultiplier(String loc, float number) {
        float hue = MathHelper.func_188207_b((float)(number - 0.5f), (float)2.0f);
        return new TranslationTextComponent(loc).func_230529_a_((ITextComponent)new StringTextComponent(Util.MULTIPLIER_FORMAT.format(number)).func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)MathHelper.func_181758_c((float)(hue / 1.5f), (float)1.0f, (float)0.75f)))));
    }
}

