/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.Util;

public class FloatToolStat
implements IToolStat<FloatBuilder> {
    private final ToolStatId name;
    private final Color color;
    private final float defaultValue;
    private final float minValue;
    private final float maxValue;

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue) {
        this.name = name;
        this.color = Color.func_240743_a_((int)color);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public float clamp(float value) {
        return MathHelper.func_76131_a((float)value, (float)this.getMinValue(), (float)this.getMaxValue());
    }

    @Override
    public FloatBuilder makeBuilder() {
        return new FloatBuilder();
    }

    public void add(ModifierStatsBuilder builder, double value) {
        builder.updateStat(this, b -> {
            FloatBuilder floatBuilder = b;
            floatBuilder.add = (float)((double)floatBuilder.add + value);
        });
    }

    public void multiply(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            FloatBuilder floatBuilder = b;
            floatBuilder.multiply = (float)((double)floatBuilder.multiply * factor);
        });
    }

    public void multiplyAll(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            FloatBuilder floatBuilder = b;
            floatBuilder.multiply = (float)((double)floatBuilder.multiply * factor);
            b.modifierMultiplier = (float)((double)b.modifierMultiplier * factor);
        });
    }

    @Override
    public float build(FloatBuilder builder, float value) {
        return (value + builder.add) * builder.multiply;
    }

    @Override
    public ITextComponent formatValue(float number) {
        return IToolStat.formatNumber(Util.makeTranslationKey("tool_stat", this.getName()), this.getColor(), number);
    }

    public String toString() {
        return "FloatToolStat{" + (Object)((Object)this.name) + '}';
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    protected static class FloatBuilder {
        private float add = 0.0f;
        private float multiply = 1.0f;
        protected float modifierMultiplier = 1.0f;
    }
}

