/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class MaterialIdNBT {
    static final MaterialIdNBT EMPTY = new MaterialIdNBT((List<MaterialId>)ImmutableList.of());
    private final List<MaterialId> materials;

    public MaterialIdNBT(List<MaterialId> materials) {
        this.materials = ImmutableList.copyOf(materials);
    }

    public MaterialId getMaterial(int index) {
        if (index >= this.materials.size() || index < 0) {
            return IMaterial.UNKNOWN_ID;
        }
        return this.materials.get(index);
    }

    public static MaterialIdNBT readFromNBT(@Nullable INBT nbt) {
        if (nbt == null || nbt.func_74732_a() != 9) {
            return EMPTY;
        }
        ListNBT listNBT = (ListNBT)nbt;
        if (listNBT.func_230528_d__() != 8) {
            return EMPTY;
        }
        List<MaterialId> materials = listNBT.stream().map(INBT::func_150285_a_).map(MaterialId::tryCreate).filter(Objects::nonNull).collect(Collectors.toList());
        return new MaterialIdNBT(materials);
    }

    public ListNBT serializeToNBT() {
        return this.materials.stream().map(ResourceLocation::toString).map(StringNBT::func_229705_a_).collect(Collectors.toCollection(ListNBT::new));
    }

    public static MaterialIdNBT from(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            return MaterialIdNBT.readFromNBT((INBT)nbt.func_150295_c("tic_materials", 8));
        }
        return EMPTY;
    }

    public ItemStack updateStack(ItemStack stack) {
        stack.func_196082_o().func_218657_a("tic_materials", (INBT)this.serializeToNBT());
        return stack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialIdNBT)) {
            return false;
        }
        MaterialIdNBT other = (MaterialIdNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<MaterialId> this$materials = this.getMaterials();
        List<MaterialId> other$materials = other.getMaterials();
        return !(this$materials == null ? other$materials != null : !((Object)this$materials).equals(other$materials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialIdNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MaterialId> $materials = this.getMaterials();
        result = result * 59 + ($materials == null ? 43 : ((Object)$materials).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialIdNBT(materials=" + this.getMaterials() + ")";
    }

    public List<MaterialId> getMaterials() {
        return this.materials;
    }
}

