/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;

public interface IModifierToolStack {
    public Item getItem();

    public ToolDefinition getDefinition();

    default public float getModifier(FloatToolStat stat) {
        return this.getDefinition().getBaseStatDefinition().getModifier(stat);
    }

    default public boolean hasTag(ITag<Item> tag) {
        return tag.func_230235_a_((Object)this.getItem());
    }

    public int getDamage();

    public int getCurrentDurability();

    public boolean isBroken();

    public boolean isUnbreakable();

    public void setDamage(int var1);

    public MaterialNBT getMaterials();

    default public List<IMaterial> getMaterialsList() {
        return this.getMaterials().getMaterials();
    }

    default public IMaterial getMaterial(int index) {
        return this.getMaterials().getMaterial(index);
    }

    public ModifierNBT getUpgrades();

    public ModifierNBT getModifiers();

    default public List<ModifierEntry> getModifierList() {
        return this.getModifiers().getModifiers();
    }

    default public int getModifierLevel(Modifier modifier) {
        return this.getModifiers().getLevel(modifier);
    }

    public StatsNBT getStats();

    public ModDataNBT getPersistentData();

    public IModDataReadOnly getVolatileData();

    default public int getFreeSlots(SlotType type) {
        return this.getPersistentData().getSlots(type) + this.getVolatileData().getSlots(type);
    }

    @Deprecated
    default public int getFreeUpgrades() {
        return this.getPersistentData().getSlots(SlotType.UPGRADE) + this.getVolatileData().getSlots(SlotType.UPGRADE);
    }

    @Deprecated
    default public int getFreeAbilities() {
        return this.getPersistentData().getSlots(SlotType.ABILITY) + this.getVolatileData().getSlots(SlotType.ABILITY);
    }
}

