/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ModifierLootingHandler {
    private static final Set<UUID> LOOTING_OFFHAND = new HashSet<UUID>();
    private static boolean init = false;

    public static void init() {
        if (init) {
            return;
        }
        init = true;
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLooting);
        MinecraftForge.EVENT_BUS.addListener(ModifierLootingHandler::onLeaveServer);
    }

    public static void setLootingHand(LivingEntity entity, Hand hand) {
        if (hand == Hand.OFF_HAND) {
            LOOTING_OFFHAND.add(entity.func_110124_au());
        } else {
            LOOTING_OFFHAND.remove(entity.func_110124_au());
        }
    }

    public static Hand getLootingHand(@Nullable LivingEntity entity) {
        return entity != null && LOOTING_OFFHAND.contains(entity.func_110124_au()) ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    private static void onLooting(LootingLevelEvent event) {
        LivingEntity holder;
        ItemStack held;
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.func_76346_g();
        if (source instanceof LivingEntity && TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)(held = (holder = (LivingEntity)source).func_184586_b(ModifierLootingHandler.getLootingHand(holder))).func_77973_b())) {
            ToolStack tool = ToolStack.from(held);
            int newLevel = ModifierUtil.getLootingLevel(tool, holder, (Entity)event.getEntityLiving(), damageSource);
            event.setLootingLevel(newLevel);
        }
    }

    private static void onLeaveServer(PlayerEvent.PlayerLoggedOutEvent event) {
        LOOTING_OFFHAND.remove(event.getPlayer().func_110124_au());
    }
}

