/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public final class ToolBaseStatDefinition {
    private final int primaryHeadWeight;
    private final Map<SlotType, Integer> startingSlots;
    private final Map<FloatToolStat, Float> bonuses;
    private final Map<FloatToolStat, Float> modifiers;

    public int getStartingSlots(SlotType type) {
        return this.startingSlots.getOrDefault(type, 0);
    }

    public Set<FloatToolStat> getAllBonuses() {
        return this.bonuses.keySet();
    }

    public float getBonus(FloatToolStat stat) {
        return this.bonuses.getOrDefault(stat, Float.valueOf(0.0f)).floatValue();
    }

    public float getModifier(FloatToolStat stat) {
        return this.modifiers.getOrDefault(stat, Float.valueOf(1.0f)).floatValue();
    }

    public void buildStats(ModifierStatsBuilder builder) {
        this.modifiers.forEach((stat, value) -> stat.multiplyAll(builder, value.floatValue()));
    }

    public void buildSlots(ModDataNBT persistentModData) {
        for (Map.Entry<SlotType, Integer> entry : this.startingSlots.entrySet()) {
            persistentModData.setSlots(entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public int getDefaultUpgrades() {
        return this.getStartingSlots(SlotType.UPGRADE);
    }

    @Deprecated
    public int getDefaultAbilities() {
        return this.getStartingSlots(SlotType.ABILITY);
    }

    @Deprecated
    public int getDefaultTraits() {
        return this.getStartingSlots(SlotType.SOUL);
    }

    protected ToolBaseStatDefinition(int primaryHeadWeight, Map<SlotType, Integer> startingSlots, Map<FloatToolStat, Float> bonuses, Map<FloatToolStat, Float> modifiers) {
        this.primaryHeadWeight = primaryHeadWeight;
        this.startingSlots = startingSlots;
        this.bonuses = bonuses;
        this.modifiers = modifiers;
    }

    public int getPrimaryHeadWeight() {
        return this.primaryHeadWeight;
    }

    public static class Builder {
        private boolean setUpgrades = false;
        private boolean setAbilities = false;
        private int primaryHeadWeight = 1;
        private final ImmutableMap.Builder<SlotType, Integer> startingSlots = ImmutableMap.builder();
        private final ImmutableMap.Builder<FloatToolStat, Float> bonuses = ImmutableMap.builder();
        private final ImmutableMap.Builder<FloatToolStat, Float> modifiers = ImmutableMap.builder();

        public Builder startingSlots(SlotType type, int value) {
            this.startingSlots.put((Object)type, (Object)value);
            if (type == SlotType.UPGRADE) {
                this.setUpgrades = true;
            } else if (type == SlotType.ABILITY) {
                this.setAbilities = true;
            }
            return this;
        }

        public Builder bonus(FloatToolStat stat, float bonus) {
            this.bonuses.put((Object)stat, (Object)Float.valueOf(bonus));
            return this;
        }

        public Builder set(FloatToolStat stat, float value) {
            this.bonuses.put((Object)stat, (Object)Float.valueOf(value - stat.getDefaultValue()));
            return this;
        }

        public Builder modifier(FloatToolStat stat, float bonus) {
            this.modifiers.put((Object)stat, (Object)Float.valueOf(bonus));
            return this;
        }

        @Deprecated
        public Builder setDefaultUpgrades(int value) {
            this.startingSlots(SlotType.UPGRADE, value);
            return this;
        }

        @Deprecated
        public Builder setDefaultAbilities(int value) {
            this.startingSlots(SlotType.ABILITY, value);
            return this;
        }

        @Deprecated
        public Builder setDefaultTraits(int value) {
            this.startingSlots(SlotType.SOUL, value);
            return this;
        }

        public ToolBaseStatDefinition build() {
            if (!this.setUpgrades) {
                this.startingSlots.put((Object)SlotType.UPGRADE, (Object)3);
            }
            if (!this.setAbilities) {
                this.startingSlots.put((Object)SlotType.ABILITY, (Object)1);
            }
            return new ToolBaseStatDefinition(this.primaryHeadWeight, (Map<SlotType, Integer>)this.startingSlots.build(), (Map<FloatToolStat, Float>)this.bonuses.build(), (Map<FloatToolStat, Float>)this.modifiers.build());
        }

        public Builder setPrimaryHeadWeight(int primaryHeadWeight) {
            this.primaryHeadWeight = primaryHeadWeight;
            return this;
        }
    }
}

