/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class MaterialCastingRecipe
extends AbstractCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    protected final int itemCost;
    protected final IMaterialItem result;
    protected Optional<MaterialFluidRecipe> cachedFluidRecipe = Optional.empty();
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(IRecipeType<?> type, ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.itemCost = itemCost;
        this.result = result;
        MaterialCastingLookup.registerItemCost(result, itemCost);
    }

    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingInventory inv) {
        return MaterialCastingLookup.getCastingFluid(inv.getFluid());
    }

    protected Optional<MaterialFluidRecipe> getCachedMaterialFluid(ICastingInventory inv) {
        Optional<MaterialFluidRecipe> fluidRecipe = this.cachedFluidRecipe;
        if (!fluidRecipe.filter(recipe -> recipe.matches(inv)).isPresent() && (fluidRecipe = this.getMaterialFluid(inv)).isPresent()) {
            this.cachedFluidRecipe = fluidRecipe;
        }
        return fluidRecipe;
    }

    public boolean matches(ICastingInventory inv, World worldIn) {
        if (!this.cast.test(inv.getStack())) {
            return false;
        }
        return this.getCachedMaterialFluid(inv).filter(recipe -> this.result.canUseMaterial(recipe.getOutput())).isPresent();
    }

    @Override
    public int getCoolingTime(ICastingInventory inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> ICastingRecipe.calcCoolingTime(recipe.getTemperature(), recipe.getFluidAmount(inv.getFluid()) * this.itemCost)).orElse(1);
    }

    @Override
    public int getFluidAmount(ICastingInventory inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> recipe.getFluidAmount(inv.getFluid())).orElse(1) * this.itemCost;
    }

    @Override
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.result);
    }

    public ItemStack getCraftingResult(ICastingInventory inv) {
        IMaterial material = this.getCachedMaterialFluid(inv).map(MaterialFluidRecipe::getOutput).orElse(IMaterial.UNKNOWN);
        return this.result.withMaterial(material);
    }

    protected List<FluidStack> resizeFluids(List<FluidStack> fluids) {
        if (this.itemCost != 1) {
            return fluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * this.itemCost)).collect(Collectors.toList());
        }
        return fluids;
    }

    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            IRecipeType<?> type = this.func_222127_g();
            List<ItemStack> castItems = Arrays.asList(this.cast.func_193365_a());
            this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> !recipe.getOutput().isHidden() && this.result.canUseMaterial(recipe.getOutput())).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(type, castItems, fluids, this.result.withMaterial(recipe.getOutput()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.consumed);
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public static class Serializer<T extends MaterialCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, JsonObject json) {
            int itemCost = JSONUtils.func_151203_m((JsonObject)json, (String)"item_cost");
            IMaterialItem result = (IMaterialItem)RecipeHelper.deserializeItem((String)JSONUtils.func_151200_h((JsonObject)json, (String)"result"), (String)"result", IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, itemCost, result, consumed, switchSlots);
        }

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, PacketBuffer buffer) {
            int fluidAmount = buffer.readInt();
            IMaterialItem result = (IMaterialItem)RecipeHelper.readItem((PacketBuffer)buffer, IMaterialItem.class);
            return this.factory.create(idIn, groupIn, cast, fluidAmount, result, consumed, switchSlots);
        }

        @Override
        protected void writeExtra(PacketBuffer buffer, MaterialCastingRecipe recipe) {
            buffer.writeInt(recipe.itemCost);
            RecipeHelper.writeItem((PacketBuffer)buffer, (IItemProvider)recipe.result);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static interface IFactory<T extends MaterialCastingRecipe> {
        public T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, int var4, IMaterialItem var5, boolean var6, boolean var7);
    }

    public static class Table
    extends MaterialCastingRecipe {
        public Table(ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_TABLE, id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableMaterialSerializer.get();
        }
    }

    public static class Basin
    extends MaterialCastingRecipe {
        public Basin(ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_BASIN, id, group, cast, itemCost, result, consumed, switchSlots);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinMaterialSerializer.get();
        }
    }
}

