/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.data.MergingJsonDataLoader;
import slimeknights.tconstruct.library.exception.TinkerAPIMaterialException;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialStatsManager
extends MergingJsonDataLoader<Map<ResourceLocation, JsonObject>> {
    private static final Logger log = LogManager.getLogger(MaterialStatsManager.class);
    public static final String FOLDER = "materials/stats";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    private final Map<MaterialStatsId, MaterialStatType<?>> materialStatTypes = new HashMap();
    private Map<MaterialId, Map<MaterialStatsId, IMaterialStats>> materialToStatsPerType = Collections.emptyMap();

    public MaterialStatsManager(Runnable onLoaded) {
        super(GSON, FOLDER, id -> new HashMap());
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialStatsManager() {
        this(() -> {});
    }

    public <T extends IMaterialStats> void registerMaterialStat(T defaultStats, Class<T> statsClass) {
        MaterialStatsId materialStatType = defaultStats.getIdentifier();
        if (this.materialStatTypes.containsKey((Object)materialStatType)) {
            throw TinkerAPIMaterialException.materialStatsTypeRegisteredTwice(materialStatType);
        }
        this.materialStatTypes.put(materialStatType, new MaterialStatType<T>(materialStatType, statsClass, defaultStats, defaultStats instanceof IRepairableMaterialStats));
    }

    @Nullable
    public Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)id);
        return type == null ? null : type.getStatsClass();
    }

    public boolean canRepair(MaterialStatsId id) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)id);
        return type != null && type.canRepair();
    }

    @Nullable
    public <T extends IMaterialStats> T getDefaultStats(MaterialStatsId statsId) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)statsId);
        return type == null ? null : (T)type.getDefaultStats();
    }

    public <T extends IMaterialStats> Optional<T> getStats(MaterialId materialId, MaterialStatsId statId) {
        Map<MaterialStatsId, IMaterialStats> materialStats = this.materialToStatsPerType.getOrDefault((Object)materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of());
        IMaterialStats stats = materialStats.get((Object)statId);
        return Optional.ofNullable(stats);
    }

    public Collection<IMaterialStats> getAllStats(MaterialId materialId) {
        return this.materialToStatsPerType.getOrDefault((Object)materialId, (Map<MaterialStatsId, IMaterialStats>)ImmutableMap.of()).values();
    }

    public void updateMaterialStatsFromServer(Map<MaterialId, Collection<IMaterialStats>> materialStats) {
        this.materialToStatsPerType = materialStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().collect(Collectors.toMap(IMaterialStats::getIdentifier, Function.identity()))));
        this.onLoaded.run();
    }

    @Override
    protected void parse(Map<ResourceLocation, JsonObject> builder, ResourceLocation id, JsonElement element) throws JsonSyntaxException {
        MaterialStatJson json = (MaterialStatJson)GSON.fromJson(element, MaterialStatJson.class);
        for (Map.Entry<ResourceLocation, JsonObject> entry : json.getStats().entrySet()) {
            builder.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected void finishLoad(Map<ResourceLocation, Map<ResourceLocation, JsonObject>> map, IResourceManager manager) {
        this.materialToStatsPerType = map.entrySet().stream().collect(Collectors.toMap(entry -> new MaterialId((ResourceLocation)entry.getKey()), entry -> this.deserializeMaterialStatsFromContent((Map)entry.getValue())));
        log.debug("Loaded stats for materials:{}", (Object)Util.toIndentedStringList(this.materialToStatsPerType.entrySet().stream().map(entry -> String.format("%s - %s", entry.getKey(), Arrays.toString(((Map)entry.getValue()).keySet().toArray()))).collect(Collectors.toList())));
        log.info("{} stats loaded for {} materials", (Object)this.materialToStatsPerType.values().stream().mapToInt(stats -> stats.keySet().size()).sum(), (Object)this.materialToStatsPerType.size());
        this.onLoaded.run();
    }

    public Object getUpdatePacket() {
        Map<MaterialId, Collection<IMaterialStats>> networkPayload = this.materialToStatsPerType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values()));
        return new UpdateMaterialStatsPacket(networkPayload);
    }

    private Map<MaterialStatsId, IMaterialStats> deserializeMaterialStatsFromContent(Map<ResourceLocation, JsonObject> contentsMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        contentsMap.forEach((loc, contents) -> {
            MaterialStatsId id = new MaterialStatsId((ResourceLocation)loc);
            this.deserializeMaterialStat(id, (JsonElement)contents).ifPresent(stats -> builder.put((Object)id, stats));
        });
        return builder.build();
    }

    private Optional<IMaterialStats> deserializeMaterialStat(MaterialStatsId statsId, JsonElement statsJson) {
        MaterialStatType<?> type = this.materialStatTypes.get((Object)statsId);
        if (type == null) {
            log.error("The material stat of type '" + (Object)((Object)statsId) + "' has not been registered");
            return Optional.empty();
        }
        return Optional.ofNullable(GSON.fromJson(statsJson, type.getStatsClass()));
    }
}

