/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.exception.TinkerJSONException;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.Material;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.materials.json.MaterialJson;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialManager
extends JsonReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialManager.class);
    public static final String FOLDER = "materials/definition";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ICondition.class, (Object)new ConditionSerializer()).setPrettyPrinting().disableHtmlEscaping().create();
    private final Runnable onLoaded;
    private Map<MaterialId, IMaterial> materials = Collections.emptyMap();
    private Map<MaterialId, MaterialId> redirects = Collections.emptyMap();
    private List<IMaterial> sortedMaterials = Collections.emptyList();

    public MaterialManager(Runnable onLoaded) {
        super(GSON, FOLDER);
        this.onLoaded = onLoaded;
    }

    @VisibleForTesting
    MaterialManager() {
        this(() -> {});
    }

    public Collection<IMaterial> getVisibleMaterials() {
        return this.sortedMaterials;
    }

    public Collection<IMaterial> getAllMaterials() {
        return this.materials.values();
    }

    public Optional<IMaterial> getMaterial(MaterialId materialId) {
        return Optional.ofNullable(this.materials.get((Object)materialId));
    }

    public MaterialId resolveRedirect(MaterialId materialId) {
        return this.redirects.getOrDefault((Object)materialId, materialId);
    }

    private void onMaterialUpdate() {
        this.sortedMaterials = this.materials.values().stream().filter(mat -> !mat.isHidden()).sorted().collect(Collectors.toList());
        this.onLoaded.run();
    }

    public void updateMaterialsFromServer(Collection<IMaterial> materialList, Map<MaterialId, MaterialId> redirects) {
        this.materials = materialList.stream().filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, Function.identity()));
        this.redirects = redirects;
        this.onMaterialUpdate();
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap<MaterialId, MaterialId> redirects = new HashMap<MaterialId, MaterialId>();
        this.materials = splashList.entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject()).map(entry -> this.loadMaterial((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject(), redirects)).filter(Objects::nonNull).collect(Collectors.toMap(IMaterial::getIdentifier, material -> material));
        Iterator redirectIterator = redirects.entrySet().iterator();
        while (redirectIterator.hasNext()) {
            Map.Entry entry2 = redirectIterator.next();
            if (this.materials.containsKey(entry2.getValue())) continue;
            log.error("Invalid material redirect {} as material {} does not exist", entry2.getKey(), entry2.getValue());
            redirectIterator.remove();
        }
        this.redirects = redirects;
        this.onMaterialUpdate();
        log.debug("Loaded materials: {}", (Object)Util.toIndentedStringList(this.materials.keySet()));
        log.debug("Loaded redirects: {}", (Object)Util.toIndentedStringList(redirects.keySet()));
        log.info("{} materials loaded", (Object)this.materials.size());
    }

    public Object getUpdatePacket() {
        return new UpdateMaterialsPacket(this.materials.values(), this.redirects);
    }

    @Nullable
    private IMaterial loadMaterial(ResourceLocation materialId, JsonObject jsonObject, Map<MaterialId, MaterialId> redirects) {
        try {
            MaterialJson materialJson = (MaterialJson)GSON.fromJson((JsonElement)jsonObject, MaterialJson.class);
            ICondition condition = materialJson.getCondition();
            if (condition != null && !condition.test()) {
                log.debug("Skipped loading material {} as it did not match the condition", (Object)materialId);
                return null;
            }
            MaterialJson.Redirect[] redirectsJson = materialJson.getRedirect();
            if (redirectsJson != null) {
                for (MaterialJson.Redirect redirect : redirectsJson) {
                    ICondition redirectCondition = redirect.getCondition();
                    if (redirectCondition != null && !redirectCondition.test()) continue;
                    MaterialId redirectTarget = new MaterialId(redirect.getId());
                    log.debug("Redirecting material {} to {}", (Object)materialId, (Object)redirectTarget);
                    redirects.put(new MaterialId(materialId), redirectTarget);
                    return null;
                }
            }
            if (materialJson.getCraftable() == null) {
                throw TinkerJSONException.materialJsonWithoutCraftingInformation(materialId);
            }
            boolean isCraftable = Boolean.TRUE.equals(materialJson.getCraftable());
            boolean hidden = Boolean.TRUE.equals(materialJson.getHidden());
            Color color = Optional.ofNullable(materialJson.getTextColor()).filter(str -> !str.isEmpty()).map(Color::func_240745_a_).orElse(Material.WHITE);
            return new Material(materialId, (Integer)LogicHelper.defaultIfNull((Object)materialJson.getTier(), (Object)0), (Integer)LogicHelper.defaultIfNull((Object)materialJson.getSortOrder(), (Object)100), isCraftable, color, hidden);
        }
        catch (Exception e) {
            log.error("Could not deserialize material {}. JSON: {}", (Object)materialId, (Object)jsonObject, (Object)e);
            return null;
        }
    }

    private static class ConditionSerializer
    implements JsonDeserializer<ICondition>,
    JsonSerializer<ICondition> {
        private ConditionSerializer() {
        }

        public ICondition deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return CraftingHelper.getCondition((JsonObject)JSONUtils.func_151210_l((JsonElement)json, (String)"condition"));
        }

        public JsonElement serialize(ICondition condition, Type type, JsonSerializationContext context) {
            return CraftingHelper.serialize((ICondition)condition);
        }
    }
}

