/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.events.MaterialsLoadedEvent;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistryImpl;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.definition.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.library.materials.stats.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.materials.traits.MaterialTraitsManager;
import slimeknights.tconstruct.library.materials.traits.UpdateMaterialTraitsPacket;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public final class MaterialRegistry {
    protected static MaterialRegistry INSTANCE;
    private final MaterialManager materialManager;
    private final MaterialStatsManager materialStatsManager;
    private final MaterialTraitsManager materialTraitsManager;
    private final IMaterialRegistry registry;
    private static boolean materialsLoaded;
    private static boolean statsLoaded;
    private static boolean traitsLoaded;
    private static boolean fullyLoaded;

    public static IMaterialRegistry getInstance() {
        return MaterialRegistry.INSTANCE.registry;
    }

    public static void init() {
        INSTANCE = new MaterialRegistry();
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::handleLogin);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ClientPlayerNetworkEvent.LoggedOutEvent.class, e -> {
            fullyLoaded = false;
        }));
    }

    public static boolean isFullyLoaded() {
        return INSTANCE != null && fullyLoaded;
    }

    public MaterialRegistry() {
        this.materialManager = new MaterialManager(() -> {
            materialsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.materialStatsManager = new MaterialStatsManager(() -> {
            statsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.materialTraitsManager = new MaterialTraitsManager(() -> {
            traitsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.registry = new MaterialRegistryImpl(this.materialManager, this.materialStatsManager, this.materialTraitsManager);
        this.registry.registerStatType(HeadMaterialStats.DEFAULT, HeadMaterialStats.class);
        this.registry.registerStatType(HandleMaterialStats.DEFAULT, HandleMaterialStats.class);
        this.registry.registerStatType(ExtraMaterialStats.DEFAULT, ExtraMaterialStats.class);
    }

    @VisibleForTesting
    MaterialRegistry(IMaterialRegistry registry) {
        this.registry = registry;
        this.materialManager = null;
        this.materialStatsManager = null;
        this.materialTraitsManager = null;
    }

    public static void updateMaterialsFromServer(UpdateMaterialsPacket packet) {
        MaterialRegistry.INSTANCE.materialManager.updateMaterialsFromServer(packet.getMaterials(), packet.getRedirects());
    }

    public static void updateMaterialStatsFromServer(UpdateMaterialStatsPacket packet) {
        MaterialRegistry.INSTANCE.materialStatsManager.updateMaterialStatsFromServer(packet.getMaterialToStats());
    }

    public static void updateMaterialTraitsFromServer(UpdateMaterialTraitsPacket packet) {
        MaterialRegistry.INSTANCE.materialTraitsManager.updateFromServer(packet.getMaterialToTraits());
    }

    public static IMaterial getMaterial(MaterialId id) {
        return MaterialRegistry.getInstance().getMaterial(id);
    }

    public static Collection<IMaterial> getMaterials() {
        return MaterialRegistry.INSTANCE.registry.getVisibleMaterials();
    }

    @Nullable
    public static Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        return MaterialRegistry.INSTANCE.materialStatsManager.getClassForStat(id);
    }

    private static void checkAllLoaded() {
        if (materialsLoaded && statsLoaded && traitsLoaded) {
            materialsLoaded = false;
            statsLoaded = false;
            traitsLoaded = false;
            fullyLoaded = true;
            MinecraftForge.EVENT_BUS.post((Event)new MaterialsLoadedEvent());
        } else {
            fullyLoaded = false;
        }
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)this.materialManager);
        event.addListener((IFutureReloadListener)this.materialStatsManager);
        event.addListener((IFutureReloadListener)this.materialTraitsManager);
    }

    private void handleLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (serverPlayer.field_71135_a.func_147298_b().func_150731_c()) {
                fullyLoaded = true;
                MinecraftForge.EVENT_BUS.post((Event)new MaterialsLoadedEvent());
            } else {
                TinkerNetwork network = TinkerNetwork.getInstance();
                PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> serverPlayer);
                network.send(target, this.materialManager.getUpdatePacket());
                network.send(target, this.materialStatsManager.getUpdatePacket());
                network.send(target, this.materialTraitsManager.getUpdatePacket());
            }
        }
    }

    static {
        materialsLoaded = false;
        statsLoaded = false;
        traitsLoaded = false;
        fullyLoaded = false;
    }
}

