/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.TransformationMatrix;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class BreakableModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = new Unbaked(-1, 0);
    private final RenderMaterial[] sprites;
    private final int color;
    private final int luminosity;
    private final ImmutableList<BakedQuad>[] quadCache = new ImmutableList[4];

    public BreakableModifierModel(@Nullable RenderMaterial normalSmall, @Nullable RenderMaterial brokenSmall, @Nullable RenderMaterial normalLarge, @Nullable RenderMaterial brokenLarge, int color, int luminosity) {
        this.color = color;
        this.luminosity = luminosity;
        this.sprites = new RenderMaterial[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    public BreakableModifierModel(@Nullable RenderMaterial normalSmall, @Nullable RenderMaterial brokenSmall, @Nullable RenderMaterial normalLarge, @Nullable RenderMaterial brokenLarge) {
        this(normalSmall, brokenSmall, normalLarge, brokenLarge, -1, 0);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry entry, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge) {
        int index = (isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0);
        if (this.quadCache[index] == null) {
            this.quadCache[index] = this.sprites[index] == null ? ImmutableList.of() : MantleItemLayerModel.getQuadsForSprite((int)this.color, (int)-1, (TextureAtlasSprite)spriteGetter.apply(this.sprites[index]), (TransformationMatrix)transforms, (int)this.luminosity);
        }
        return this.quadCache[index];
    }

    private static class Unbaked
    implements IUnbakedModifierModel {
        private final int color;
        private final int luminosity;

        @Override
        @Nullable
        public IBakedModifierModel forTool(Function<String, RenderMaterial> smallGetter, Function<String, RenderMaterial> largeGetter) {
            RenderMaterial normalSmall = smallGetter.apply("");
            RenderMaterial brokenSmall = smallGetter.apply("_broken");
            RenderMaterial normalLarge = smallGetter.apply("");
            RenderMaterial brokenLarge = smallGetter.apply("_broken");
            if (normalSmall != null || brokenSmall != null || normalLarge != null || brokenLarge != null) {
                return new BreakableModifierModel(normalSmall, brokenSmall, normalLarge, brokenLarge, this.color, this.luminosity);
            }
            return null;
        }

        @Override
        public IUnbakedModifierModel configure(JsonObject data) {
            int color = JsonHelper.parseColor((String)JSONUtils.func_151219_a((JsonObject)data, (String)"color", (String)""));
            int luminosity = JSONUtils.func_151203_m((JsonObject)data, (String)"luminosity");
            if (color != this.color || luminosity != this.luminosity) {
                return new Unbaked(color, luminosity);
            }
            return this;
        }

        public Unbaked(int color, int luminosity) {
            this.color = color;
            this.luminosity = luminosity;
        }
    }
}

