/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.tconstruct.library.book.TinkerPage;
import slimeknights.tconstruct.library.book.elements.ListingLeftElement;

@OnlyIn(value=Dist.CLIENT)
public class ContentListing
extends TinkerPage {
    public String title = null;
    public String subText = null;
    private final transient List<TextData> entries = Lists.newArrayList();

    public void addEntry(String text, @Nullable PageData link) {
        TextData data = new TextData(text);
        if (link != null) {
            data.action = "go-to-page-rtn:" + link.parent.name + "." + link.name;
        }
        this.entries.add(data);
    }

    public boolean hasEntries() {
        return this.entries.size() > 0;
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int lineHeight;
        int columnHeight;
        int yOff = 0;
        if (this.title != null) {
            this.addTitle(list, this.title, false);
            yOff = 16;
        }
        if (this.subText != null) {
            int height = this.addText(list, this.subText, false, 0, yOff);
            yOff += height;
        }
        if ((columnHeight = BookScreen.PAGE_HEIGHT - yOff - 16) % (lineHeight = 10) != 0) {
            columnHeight -= columnHeight % lineHeight;
        }
        int w = BookScreen.PAGE_WIDTH;
        int totalHeight = this.entries.size() * lineHeight;
        if (totalHeight > columnHeight) {
            w = totalHeight > columnHeight * 2 ? (w /= 3) : (w /= 2);
        }
        int x = 0;
        int y = 0;
        for (TextData data : this.entries) {
            int height = this.parent.parent.parent.fontRenderer.func_78267_b("- " + data.text, w) * lineHeight / 9;
            list.add((BookElement)this.createListingElement(y + yOff, x, w, height, data));
            if ((y += height) < columnHeight) continue;
            x += w;
            y = 0;
        }
    }

    private ListingLeftElement createListingElement(int y, int x, int w, int line_height, TextData data) {
        return new ListingLeftElement(x, y, w, line_height, data);
    }
}

