/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.gadgets.entity.FrameType;

public class FancyItemFrameEntity
extends ItemFrameEntity
implements IEntityAdditionalSpawnData {
    private static final int DIAMOND_TIMER = 300;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(FancyItemFrameEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String TAG_VARIANT = "Variant";
    private static final String TAG_ROTATION_TIMER = "RotationTimer";
    private int rotationTimer = 0;

    public FancyItemFrameEntity(EntityType<? extends FancyItemFrameEntity> type, World world) {
        super(type, world);
    }

    public FancyItemFrameEntity(World worldIn, BlockPos blockPos, Direction face, FrameType variant) {
        super((EntityType)TinkerGadgets.itemFrameEntity.get(), worldIn);
        this.field_174861_a = blockPos;
        this.func_174859_a(face);
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant.getId());
    }

    private static boolean doesRotate(int type) {
        return type == FrameType.GOLD.getId() || type == FrameType.REVERSED_GOLD.getId() || type == FrameType.DIAMOND.getId();
    }

    public void updateRotationTimer(boolean overturn) {
        this.rotationTimer = overturn ? -300 : 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int frameId = this.getFrameId();
        if (frameId == FrameType.DIAMOND.getId()) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 300) {
                int curRotation;
                this.rotationTimer = 0;
                if (!this.field_70170_p.field_72995_K && (curRotation = this.func_82333_j()) > 0) {
                    this.func_82336_g(curRotation - 1);
                }
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && FancyItemFrameEntity.doesRotate(frameId)) {
            ++this.rotationTimer;
            if (this.rotationTimer >= 20) {
                this.rotationTimer = 0;
                int curRotation = this.func_82333_j();
                if (frameId == FrameType.REVERSED_GOLD.getId()) {
                    if (--curRotation == -1) {
                        curRotation = 7;
                    }
                    this.func_82336_g(curRotation);
                } else {
                    this.func_82336_g(curRotation + 1);
                }
            }
        }
    }

    public void func_174864_a(ItemStack stack, boolean updateComparator) {
        super.func_174864_a(stack, updateComparator);
        if (updateComparator && !this.field_70170_p.field_72995_K && FancyItemFrameEntity.doesRotate(this.getFrameId())) {
            this.func_174865_a(0, false);
        }
    }

    private void setRotationRaw(int rotationIn, boolean updateComparator) {
        this.func_184212_Q().func_187227_b(field_184526_d, (Object)rotationIn);
        if (updateComparator && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    protected void func_174865_a(int rotationIn, boolean updateComparator) {
        this.rotationTimer = 0;
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            if (!this.field_70170_p.field_72995_K && updateComparator) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.setRotationRaw(Math.min(rotationIn, 16), updateComparator);
        } else {
            this.setRotationRaw(rotationIn % 8, updateComparator);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public FrameType getFrameType() {
        return FrameType.byId(this.getFrameId());
    }

    public Item getFrameItem() {
        return (Item)TinkerGadgets.itemFrame.get((Enum)this.getFrameType());
    }

    protected int getFrameId() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Nullable
    public ItemEntity func_70099_a(ItemStack stack, float offset) {
        if (stack.func_77973_b() == Items.field_151160_bD) {
            stack = new ItemStack((IItemProvider)this.getFrameItem());
        }
        return super.func_70099_a(stack, offset);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack held = this.func_82335_i();
        if (held.func_190926_b()) {
            return new ItemStack((IItemProvider)this.getFrameItem());
        }
        return held.func_77946_l();
    }

    public boolean func_230279_az_() {
        return super.func_230279_az_() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public boolean func_180427_aV() {
        return super.func_180427_aV() || this.getFrameId() == FrameType.NETHERITE.getId();
    }

    public int func_174866_q() {
        if (this.func_82335_i().func_190926_b()) {
            return 0;
        }
        int rotation = this.func_82333_j();
        if (this.getFrameId() == FrameType.DIAMOND.getId()) {
            return Math.min(15, rotation + 1);
        }
        return rotation % 8 + 1;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        int frameId = this.getFrameId();
        compound.func_74768_a(TAG_VARIANT, frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            compound.func_74768_a(TAG_ROTATION_TIMER, this.rotationTimer);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        int frameId = compound.func_74762_e(TAG_VARIANT);
        this.field_70180_af.func_187227_b(VARIANT, (Object)frameId);
        if (FancyItemFrameEntity.doesRotate(frameId)) {
            this.rotationTimer = compound.func_74762_e(TAG_ROTATION_TIMER);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(this.getFrameId());
        buffer.func_179255_a(this.field_174861_a);
        buffer.func_150787_b(this.field_174860_b.func_176745_a());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)buffer.func_150792_a());
        this.field_174861_a = buffer.func_179259_c();
        this.func_174859_a(Direction.func_82600_a((int)buffer.func_150792_a()));
    }

    protected ITextComponent func_225513_by_() {
        return new TranslationTextComponent(this.getFrameItem().func_77658_a());
    }
}

