/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.mod.math.Vec3d;
import util.Matrix4;

public class VecUtil {
    private VecUtil() {
    }

    public static Vec3d fromYaw(double distance, float yaw) {
        return new Vec3d(Math.sin(Math.toRadians(yaw)) * distance, 0.0, Math.cos(Math.toRadians(yaw)) * distance);
    }

    public static float toYaw(Vec3d delta) {
        float yaw = (float)Math.toDegrees(Math.atan2(delta.x, delta.z));
        return (yaw + 360.0f) % 360.0f;
    }

    public static Vec3d rotateYaw(Vec3d pos, float rotationYaw) {
        return new Matrix4().rotate(Math.toRadians(rotationYaw - 90.0f), 0.0, 1.0, 0.0).apply(pos);
    }

    public static Vec3d rotatePitch(Vec3d pos, float rotationPitch) {
        return new Matrix4().rotate(Math.toRadians(rotationPitch), 0.0, 0.0, 1.0).apply(pos);
    }

    public static Vec3d fromWrongYaw(double distance, float yaw) {
        return new Vec3d(-Math.sin(Math.toRadians(yaw)) * distance, 0.0, Math.cos(Math.toRadians(yaw)) * distance);
    }

    public static float toWrongYaw(Vec3d delta) {
        float yaw = (float)Math.toDegrees(Math.atan2(-delta.x, delta.z));
        return (yaw + 360.0f) % 360.0f;
    }

    public static float toPitch(Vec3d delta) {
        float yaw = (float)Math.toDegrees(Math.atan2(Math.sqrt(delta.z * delta.z + delta.x * delta.x), delta.y));
        return (yaw + 360.0f) % 360.0f;
    }

    public static Vec3d rotateWrongYaw(Vec3d pos, float rotationYaw) {
        return VecUtil.fromWrongYaw(pos.x, rotationYaw).add(VecUtil.fromWrongYaw(pos.z, rotationYaw + 90.0f).add(0.0, pos.y, 0.0));
    }

    public static Vec3d fromWrongYawPitch(float distance, float rotationYaw, float rotationPitch) {
        return VecUtil.fromWrongYaw(distance, rotationYaw).add(0.0, Math.tan(Math.toRadians(rotationPitch)) * (double)distance, 0.0);
    }

    public static Vec3d between(Vec3d front, Vec3d rear) {
        return new Vec3d((front.x + rear.x) / 2.0, (front.y + rear.y) / 2.0, (front.z + rear.z) / 2.0);
    }
}

