/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.render.DisplayListCache;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class RailBaseRender {
    private static DisplayListCache displayLists = new DisplayListCache();

    private static synchronized void drawSync(RailInfo info, World world) {
        if (info.settings.railBed.isEmpty()) {
            return;
        }
        StandardModel model = new StandardModel();
        for (TrackBase base : info.getBuilder(world).getTracksForRender()) {
            model.addItemBlock(info.settings.railBed, new Vec3d(base.getPos()), new Vec3d(1.0, (double)(base.getBedHeight() + 0.1f * (float)info.settings.gauge.scale()), 1.0));
        }
        model.render();
    }

    public static void draw(RailInfo info, World world) {
        Integer displayList = (Integer)displayLists.get(info.uniqueID);
        if (displayList == null) {
            displayList = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayList, (int)4864);
            RailBaseRender.drawSync(info, world);
            GL11.glEndList();
            displayLists.put(info.uniqueID, displayList);
        }
        GL11.glCallList((int)displayList);
    }
}

