/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;

public class Frame {
    private final ModelComponent frame;
    private final WheelSet wheels;
    private final ValveGear valveGearRight;
    private final ValveGear valveGearLeft;

    public Frame(ComponentProvider provider, String blame, ValveGearType type) {
        this.wheels = WheelSet.get(provider, ModelComponentType.FRAME_WHEEL_X, 0.0f);
        this.frame = provider.parse(ModelComponentType.FRAME);
        if (this.frame == null) {
            ImmersiveRailroading.warn((String)"Invalid model: Missing FRAME for %s!  (this will fail in future versions of IR)", (Object[])new Object[]{blame});
        }
        this.valveGearRight = this.wheels != null ? ValveGear.get(this.wheels, type, provider, "RIGHT", -90.0f) : null;
        this.valveGearLeft = this.wheels != null ? ValveGear.get(this.wheels, type, provider, "LEFT", 0.0f) : null;
    }

    public void render(double distance, ComponentRenderer draw) {
        draw.render(this.frame);
        if (this.wheels != null) {
            this.wheels.render(distance, draw);
        }
        if (this.valveGearRight != null) {
            this.valveGearRight.render(distance, 0.0f, draw);
        }
        if (this.valveGearLeft != null) {
            this.valveGearLeft.render(distance, 0.0f, draw);
        }
    }
}

