/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJVBO;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ComponentRenderer
implements Closeable {
    private final OBJVBO.BoundOBJVBO vbo;
    private final List<ModelComponent> buffer = new ArrayList<ModelComponent>();
    private final List<ModelComponentType> available;
    private final OpenGL.With matrix;

    public ComponentRenderer(OBJVBO.BoundOBJVBO vbo, List<ModelComponentType> available) {
        this.vbo = vbo;
        this.available = available;
        this.matrix = OpenGL.matrix();
    }

    public void render(ModelComponent component) {
        if (component != null && (this.available == null || this.available.remove((Object)component.type))) {
            this.buffer.add(component);
        }
    }

    public void render(ModelComponent ... components) {
        for (ModelComponent component : components) {
            this.render(component);
        }
    }

    public void render(Collection<ModelComponent> components) {
        for (ModelComponent component : components) {
            this.render(component);
        }
    }

    public ComponentRenderer push() {
        return new ComponentRenderer(this.vbo, this.available);
    }

    @Override
    public void close() {
        if (this.buffer.size() == 1) {
            this.vbo.draw(this.buffer.get((int)0).modelIDs);
        } else if (this.buffer.size() > 1) {
            this.vbo.draw((Collection)this.buffer.stream().flatMap(x -> x.modelIDs.stream()).collect(Collectors.toList()));
        }
        this.matrix.restore();
    }
}

