/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.util.SpawnUtil;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.world.World;
import java.util.List;

public abstract class BaseItemRollingStock
extends CustomItem {
    public BaseItemRollingStock(String modID, String name) {
        super(modID, name);
    }

    public String getCustomName(ItemStack stack) {
        EntityRollingStockDefinition def = new Data((ItemStack)stack).def;
        return def == null ? null : def.name();
    }

    public static ClickResult tryPlaceStock(Player player, World worldIn, Vec3i pos, Player.Hand hand, List<ItemComponentType> parts) {
        ItemStack stack = player.getHeldItem(hand);
        EntityRollingStockDefinition def = new Data((ItemStack)stack).def;
        if (def == null) {
            player.sendMessage(ChatText.STOCK_INVALID.getMessage(new Object[0]));
            return ClickResult.REJECTED;
        }
        if (parts == null) {
            parts = def.getItemComponents();
        }
        return SpawnUtil.placeStock(player, hand, worldIn, pos, def, parts);
    }

    protected static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="defID")
        public EntityRollingStockDefinition def;
        @TagField(value="gauge")
        public Gauge gauge;
        @TagField(value="texture_variant")
        public String texture;

        protected Data(ItemStack stack) {
            super(stack);
            if (this.gauge == null) {
                Gauge gauge = this.gauge = this.def != null ? this.def.recommended_gauge : Gauge.from(1.435);
            }
            if (this.def != null && !this.def.textureNames.containsKey(this.texture)) {
                this.texture = null;
            }
        }
    }
}

