/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.tile.IInfinityTileEntityType;
import com.infinityraider.infinitylib.config.Config;
import com.infinityraider.infinitylib.container.IInfinityContainerType;
import com.infinityraider.infinitylib.entity.EmptyEntityRenderFactory;
import com.infinityraider.infinitylib.entity.IInfinityEntityType;
import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.modules.Module;
import com.infinityraider.infinitylib.particle.IInfinityParticleType;
import com.infinityraider.infinitylib.particle.ParticleHelper;
import com.infinityraider.infinitylib.proxy.IProxy;
import com.infinityraider.infinitylib.proxy.base.IClientProxyBase;
import com.infinityraider.infinitylib.render.fluid.InfFluidRenderer;
import com.infinityraider.infinitylib.render.item.InfItemRendererRegistry;
import com.infinityraider.infinitylib.render.model.ModelLoaderRegistrar;
import com.infinityraider.infinitylib.render.model.TransformingFaceBakery;
import com.infinityraider.infinitylib.render.tile.ITileRenderer;
import com.infinityraider.infinitylib.render.tile.TileEntityRendererWrapper;
import com.infinityraider.infinitylib.utility.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements IProxy,
IClientProxyBase<Config> {
    @Override
    public void registerRegistrables(InfinityMod<?, ?> mod) {
        IProxy.super.registerRegistrables(mod);
        mod.getModModelLoaders().forEach(loader -> ModelLoaderRegistrar.getInstance().registerModelLoader(loader));
    }

    @Override
    public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        IProxy.super.onCommonSetupEvent(event);
        Module.getActiveModules().forEach(Module::initClient);
        TransformingFaceBakery.init();
        InfFluidRenderer.init();
    }

    @Override
    public void onClientSetupEvent(FMLClientSetupEvent event) {
        Module.getActiveModules().forEach(Module::postInit);
        Module.getActiveModules().forEach(Module::postInitClient);
    }

    @Override
    public void registerFMLEventHandlers(IEventBus bus) {
        IProxy.super.registerFMLEventHandlers(bus);
        bus.addListener(ModelLoaderRegistrar.getInstance()::registerModelLoaders);
        bus.addListener(ParticleHelper.getInstance()::onFactoryRegistration);
    }

    @Override
    public void registerEventHandlers() {
        IProxy.super.registerEventHandlers();
        this.registerEventHandler(ModelLoaderRegistrar.getInstance());
        for (Module module : Module.getActiveModules()) {
            module.getClientEventHandlers().forEach(this::registerEventHandler);
        }
    }

    @Override
    public void registerGuiContainer(IInfinityContainerType containerType) {
        IInfinityContainerType.IGuiFactory<?> factory = containerType.getGuiFactory();
        if (factory != null) {
            ScreenManager.func_216911_a((ContainerType)((ContainerType)containerType.cast()), IInfinityContainerType.castGuiFactory(factory));
        }
    }

    @Override
    public <T extends IParticleData> void onParticleRegistration(IInfinityParticleType<T> particleType) {
        ParticleHelper.getInstance().registerType(particleType);
    }

    @Override
    public void registerRenderers(InfinityMod<?, ?> mod) {
        this.registerBlockRenderers(mod.getModBlockRegistry());
        this.registerTileRenderers(mod.getModTileRegistry());
        this.registerItemRenderers(mod.getModItemRegistry());
        this.registerEntityRenderers(mod.getModEntityRegistry());
    }

    private void registerBlockRenderers(Object blockRegistry) {
        if (blockRegistry == null) {
            return;
        }
        ReflectionHelper.forEachValueIn(blockRegistry, IInfinityBlock.class, object -> {
            RenderTypeLookup.setRenderLayer((Block)((Block)object.cast()), (RenderType)object.getRenderType());
            IBlockColor color = object.getColor();
            if (color != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(color, new Block[]{(Block)object.cast()});
            }
        });
    }

    private void registerTileRenderers(Object tileRegistry) {
        if (tileRegistry == null) {
            return;
        }
        ReflectionHelper.forEachValueIn(tileRegistry, IInfinityTileEntityType.class, object -> {
            ITileRenderer<? extends TileEntity> renderer = object.getRenderer();
            if (renderer != null) {
                ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)object.cast()), dispatcher -> TileEntityRendererWrapper.createWrapper(dispatcher, renderer));
            }
        });
    }

    private void registerItemRenderers(Object itemRegistry) {
        if (itemRegistry == null) {
            return;
        }
        ReflectionHelper.forEachValueIn(itemRegistry, IInfinityItem.class, object -> {
            InfItemRendererRegistry.getInstance().register((IInfinityItem)object);
            object.getModelProperties().forEach(prop -> ItemModelsProperties.func_239418_a_((Item)((Item)object.cast()), (ResourceLocation)prop.getId(), prop::getValue));
        });
    }

    private void registerEntityRenderers(Object entityRegistry) {
        if (entityRegistry == null) {
            return;
        }
        ReflectionHelper.forEachValueIn(entityRegistry, IInfinityEntityType.class, object -> {
            if (object.getRenderFactory() == null) {
                InfinityLib.instance.getLogger().info("", "No entity rendering factory was found for entity " + object.getInternalName());
                RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)object.cast()), EmptyEntityRenderFactory.getInstance());
            } else {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)object.cast()), object.getRenderFactory());
            }
        });
    }

    @Override
    public void forceClientRenderUpdate(BlockPos pos) {
        Minecraft.func_71410_x().field_71438_f.func_147585_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }
}

