/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.synchronizedeffects;

import com.google.common.primitives.Ints;
import com.infinityraider.infinitylib.modules.synchronizedeffects.MessageSyncEffects;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;

public class EffectTracker
implements ISerializable {
    private final LivingEntity entity;
    private Set<Integer> activeEffects = new HashSet<Integer>();

    protected EffectTracker(LivingEntity entity) {
        this.entity = entity;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public void updatePotionEffects(List<Effect> effects) {
        boolean update = false;
        Iterator<Integer> it = this.activeEffects.iterator();
        while (it.hasNext()) {
            int id = it.next();
            Effect effect = Effect.func_188412_a((int)id);
            if (!effects.contains(effect)) {
                it.remove();
                update = true;
                continue;
            }
            effects.remove(effect);
        }
        if (effects.size() > 0) {
            this.activeEffects.addAll(effects.stream().map(Effect::func_188409_a).collect(Collectors.toList()));
            update = true;
        }
        if (update) {
            this.syncToClient();
        }
    }

    public List<Effect> getActiveEffects() {
        return this.activeEffects.stream().map(Effect::func_188412_a).collect(Collectors.toList());
    }

    protected void syncToClient() {
        new MessageSyncEffects(this).sendToAll();
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.activeEffects.clear();
        if (tag.func_74764_b("IL_EFFECTS")) {
            this.activeEffects = Arrays.stream(tag.func_74759_k("IL_EFFECTS")).boxed().collect(Collectors.toSet());
        }
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74783_a("IL_EFFECTS", Ints.toArray(this.activeEffects));
        return tag;
    }
}

